'use strict';

if (!("Func" in this))
{
    var Func = {

        sum : function(a, b) { 
        	return a + b; 
        },
        sq : function(a, b) { 
        	return Math.sqrt(a*a + b*b); 
        },
        min : function(a, b) { 
        	return Math.min(a, b); 
        },
        max : function(a, b) { 
        	return Math.max(a, b); 
        },
        avg : function(arr)  { 
        	return arr.reduce(this.Sum, 0)/arr.length; 
        }
        stat : function(arr, func)
        {
            if (arr.length==0)
                return undefined;

            var sum = 0;
            var sq  = 0;
            var cnt = 0;
            var min = arr[0];
            var max = arr[0];
            arr.forEach(
            	function(val, idx) { 
            		sum+=val; 
            		sq+=val*val; 
            		if (val>max) 
            			max=val; 
            		if (val<min) 
            			min=val; 
            		if (func && func(val, idx)) 
            			cnt++ 
            	}
            );
            sum /= arr.length;
            sq  /= arr.length;

            return { avg:sum, rms:Math.sqrt(sq-sum*sum), min:min, max:max, count:cnt };
        },
	};
}
else{
    console.out("multiple include of 'Func.js'")
}
