

void currents(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    Double_t jd;

    Float_t med, dev;
    file.SetPtrAddress("Time",  &time);
    file.SetPtrAddress("I_med", &med);
    file.SetPtrAddress("I_dev", &dev);

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    double med_beg  = 0;
    double med_end  = 0;
    double med_avg  = 0;
    double med_rms  = 0;
    double dev_avg  = 0;
    double dev_rms  = 0;
    int    cnt  = 0;
    int    cnt_beg  = 0;
    int    cnt_end  = 0;

    double med_last = -1;
    double dev_last = -1;
    double diff = -1;

    double calc_dev_avg  = 0;

    while (file.GetNextRow())
    {
        time += offset;
        jd    = time + 2400000.5;

        if (time>end)
            break;

        if (time<beg)
        {
            med_last = med;
            dev_last = dev;
            diff = beg-time;
            continue;
        }

        med_avg += med;
        med_rms += med*med;
        dev_avg += dev;
        dev_rms += dev*dev;

        if (time<beg+15./24/3600)
        {
            med_beg += med;
            cnt_beg++;
        }
        if (time>end-15./24/3600)
        {
            med_end += med;
            cnt_end++;
        }

        //calculate the moon
        Nova::EquPosn moon = Nova::GetLunarEquCoords(jd, 0.01);
        // get local position of moon
        Nova::HrzPosn hrzm = Nova::GetHrzFromEqu(moon, jd);

        //calculate the light condition
        double calt = sin(hrzm.alt*TMath::DegToRad());
        double disk = Nova::GetLunarDisk(jd);
        double lc = calt*pow(disk, 2.5);

        double Ical = lc>0 ? 4.5+103.0*lc : 4.5;
        calc_dev_avg += med - Ical;

        cnt++;
    }

    if (cnt==0)
    {
        if (diff<5./24/3600)
            return;

        cout << "result " << med_last << " 0 " << dev_last << " 0 0 0 0" << endl;
        return;
    }

    med_beg = cnt_beg>0 ? med_beg/cnt_beg : -1;
    med_end = cnt_end>0 ? med_end/cnt_end : -1;

    med_avg /= cnt;
    med_rms /= cnt;
    med_rms = sqrt(med_rms-med_avg*med_avg);

    dev_avg /= cnt;
    dev_rms /= cnt;
    dev_rms = sqrt(dev_rms-dev_avg*dev_avg);
    calc_dev_avg = calc_dev_avg / cnt;

    cout << "result " << med_avg << " " << med_rms << " " << dev_avg << " " << dev_rms << " " << med_beg << " " << med_end << " " << calc_dev_avg << endl;
}
