void drstemp(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    Float_t temp[82];
    file.SetPtrAddress("Time", &time);
    file.SetPtrAddress("temp", temp);

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    double avgmin = 0;
    double avgmax = 0;
    double rmsmin = 0;
    double rmsmax = 0;

    int cnt = 0;

    double lastavgmin = -1;
    double lastavgmax = -1;
    double lastrmsmin = -1;
    double lastrmsmax = -1;

    double diff  = -1;

    while (file.GetNextRow())
    {
        time += offset;

        if (time>end)
            break;

        double mn = 0;
        double mx = 0;
        double rn = 0;
        double rx = 0;
        for (int i=1; i<=40; i++)
        {
            mn += temp[i];
            rn += temp[i]*temp[i];

            mx += temp[i+41];
            rx += temp[i+41]*temp[i+41];
        }
        mn /= 40;
        mx /= 40;
        rn /= 40;
        rx /= 40;

        if (time<beg)
        {
            lastavgmin  = mn;
            lastavgmax  = mx;
            lastrmsmin  = sqrt(rn-mn*mn);
            lastrmsmax  = sqrt(rx-mx*mx);
            diff  = beg-time;
            continue;
        }

        avgmin += mn;
        avgmax += mx;

        rmsmin += sqrt(rn-mn*mn);
        rmsmax += sqrt(rx-mx*mx);

        cnt ++;
    }

    if (cnt==0)
    {
        if (diff<5./24/3600)
            return;

        cout << "result " << lastavgmin << " " << lastavgmax << " " << lastrmsmin << " " << lastrmsmax << endl;
        return;
    }

    avgmin /= cnt;
    avgmax /= cnt;
    rmsmin /= cnt;
    rmsmax /= cnt;

    cout << "result " << avgmin << " " << avgmax << " " << rmsmin << " " << rmsmax << endl;
}
