#ifndef __MMCOMP_H__
#define __MMCOMP_H__

#include <TH1F.h>
#include <TApplication.h>
#include <TGClient.h>
#include <TMinuit.h>
#include <TROOT.h>
#include <TSystem.h>
#include <TStopwatch.h>
#include <TRandom3.h>
#include <algorithm>
#include <iostream>
#include <unistd.h>
#include <TRandom3.h>
#include <string>
#include <TChain.h>
#include "TCanvas.h"

#include "../../mbase/MTime.h"
#include "../../mimage/MHillas.h"
#include "../../mimage/MImagePar.h"
#include "../../mimage/MNewImagePar.h"
//#include "../../mmc/MMcEvtBasic.h"

//#include "/home/guest/ghughes/FACT/Mars_McMismatchStudy/libmars.so"

//#define N_SIZE   100
//#define MIN_SIZE 1.
//#define MAX_SIZE 5.

using namespace std;

class MMCComp 
{

private:
   TChain *cDATA;
   TChain *cMC;

   MTime  *timeDATA;
   MHillas *hillasDATA;
   MImagePar *imageparDATA;
   MNewImagePar *newimageparDATA;

   MHillas *hillasMC;
   MImagePar *imageparMC;
   MNewImagePar *newimageparMC;
   //MMcEvtBasic *mcEvent;

public:
   MMCComp();
   void    Print() const;
   void    loadData( string sDataDir );
   void    loadMC( string sDataDir );

   void    compareSize( int N_SIZE, double MIN_SIZE, double MAX_SIZE );
   void    compareLength( int N_Length, double MIN_Length, double MAX_Length );
   void    compareWidth( int N_Width, double MIN_Width, double MAX_Width );

};

#endif

