#define PI 3.1415
#define D2R PI/180.
#define R2D 180./PI

void useTables( string sInFile, string sTableFile )
{

  gStyle->SetOptStat(111111);
  gStyle->SetOptFit(111111);

  gStyle->SetOptStat(0);

  TFile *fTableFile = new TFile( sTableFile.c_str() );
  if( fTableFile->IsZombie() )
  {
    cout << "File Error " << sTableFile.c_str() << endl;
    exit(-1);
  }

  TFile *fInFile = new TFile( sInFile.c_str() );
  if( fInFile->IsZombie() )
  {
    cout << "File Error " << sInFile.c_str() << endl;
    exit(-1);
  }

  TTree *hTree = (TTree*)fInFile->Get("hillastree");

  float  fMCEnergy;
  float  fMCZd;
  double fLength;
  double fWidth;
  double fDistance;
  double fSize;

  hTree->SetBranchAddress("MCEnergy",&fMCEnergy);
  hTree->SetBranchAddress("MCZd",&fMCZd);
  hTree->SetBranchAddress("Length",&fLength);
  hTree->SetBranchAddress("Width",&fWidth);
  hTree->SetBranchAddress("Size",&fSize);
  hTree->SetBranchAddress("Distance",&fDistance);

  TH2F *hTableEnergy = (TH2F*)fTableFile->Get("hTableEnergy");
  TH2F *hTableLength = (TH2F*)fTableFile->Get("hTableLength");
  TH2F *hTableWidth  = (TH2F*)fTableFile->Get("hTableWidth");
  TH2F *hTableNorm   = (TH2F*)fTableFile->Get("hTableNorm");

  TH1F *hRes = new TH1F("hRes","Energy Resolution",30,-2.,2.);
  hRes->GetXaxis()->SetTitle("(Energy-True)/True");

  int BIG = int(hTree->GetEntries()/2.);

  for( int i = BIG; i < hTree->GetEntries(); i++ )
  {

    hTree->GetEntry(i);

    if( fabs(fMCZd*R2D - 10.) < 5.0 )
    {
      Int_t iX = hTableEnergy->GetXaxis()->FindBin(log10(fSize));
      Int_t iY = hTableEnergy->GetYaxis()->FindBin(fDistance);

      float energy = hTableEnergy->GetBinContent(iX,iY);

      if( energy != 0. ) hRes->Fill((pow(10.,energy)-fMCEnergy)/fMCEnergy);

    }

  }

  hRes->Draw();
  hRes->Fit("gaus");

}
