/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  2013 <mailto:thomas.bretz@epfl.ch>
!
!   Copyright: MAGIC Software Development, 2000-2013
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// MHDrsCalibration
//
///////////////////////////////////////////////////////////////////////
#include "MDrsCalibrationTime.h"

#include <TH1.h>

ClassImp(MDrsCalibrationTime);

using namespace std;

bool MDrsCalibrationTime::SetDelays(const TH1 &cam)
{
    if (cam.GetDimension()!=1)
        return false;

    fDelays.assign(cam.GetNbinsX(), 0);

    for (int i=0; i<cam.GetNbinsX(); i++)
        fDelays[i] = cam.GetBinContent(i+1);

    return true;
}
