#!/bin/bash

source ~/.bash_profile

cd $MARSSYS

YEAR=YYYYY
MONTH=MMMMM
DAY=DDDDD

DATE=$YEAR$MONTH$DAY

SEQDIR="/scratch/fact/sequences/"$YEAR"/"$MONTH"/"$DAY"/"
INDIR="/scratch/fact/data.2013.05.11/callisto/"$YEAR"/"$MONTH"/"$DAY"/"
OUTDIR=$MARSSYS"/OUTPUT/star/"$DATE"/"

TFILE=${MARSSYS}"/"$DATE".tempfile"

ls $SEQDIR/${DATE}_???.seq > $TFILE

while read LINE
do

  SEQFILE=$LINE
  root -b -q fact/analysis/star.C\(\"$SEQFILE\",4,2.5,\"$INDIR\",\"$OUTDIR\"\)
  root -b -q fact/analysis/merpp.C\(\"$SEQFILE\",\"$OUTDIR\"\)

done <$TFILE

rm $TFILE



