#!/bin/bash

if [[ $# < 1 ]]
then
  echo ""
  echo "FACT.sub_gan_data.sh <runlist>"
  echo ""
  echo "<runlist> should be in the form DIRECTOR FILE eg:"
  echo "/home/guest/ghughes/FACT/Mars_McMismatchStudy/OUTPUT/star/20131001/ 20131001_074_I.root"
  echo ""
  exit
fi

cd $MARSSYS

INFILE=$MARSSYS"/batch/"$1

while read LINE
do

  NAME=`echo $LINE | gawk '{print $2}' | grep root | sed s/.root//g`
  echo $LINE >  $NAME.list

  QSUB=$MARSSYS"/batch/queue/FACT.qsub_gan_data_"$NAME".sh"

  QSUBERR=$MARSSYS"/batch/queue/FACT.qsub_gan_data_"$NAME".err"
  QSUBOUT=$MARSSYS"/batch/queue/FACT.qsub_gan_data_"$NAME".out"

  sed -e "s|NNNNN|$NAME|"  $MARSSYS"/batch/FACT.qsub_gan_data.sh" > $QSUB

  chmod +x $QSUB

  ##qsub -q fact_medium -b yes -o $QSUBOUT -e $QSUBERR $QSUB
  qsub -q test -b yes -o $QSUBOUT -e $QSUBERR $QSUB

done <$INFILE
