#ifndef MARS_MEnergyTable
#define MARS_MEnergyTable

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#include <vector>
#include "TH2F.h"

#define D2R 3.1415/180.

#ifndef MARS_MParameterCalc
#include "MParameterCalc.h"
#endif

using namespace std;

class MHillasSrc;
class MEnergyEst;
class MHillas;
class MNewImagePar;
class MMcEvt;
class MHMatrix;
class MPointingPos;
class MParameterD;

class MEnergyTable : public MParameterCalc
{
private:

    MParameterD   *fParameterW;
    MParameterD   *fParameterL;
    MParameterD   *fParameter;
    MHillasSrc    *fHillasSrc;
    MHillas       *fHillas;
    MPointingPos  *fPointing;
    MMcEvt        *fMC;

    TString   fNameHillasSrc;
    TString   fNameHillas;
    TString   fNamePoint;
    TString   fNameMC;
    TString   fNameParameter;
    TString   fNameParameterW;
    TString   fNameParameterL;

    Double_t fMm2Deg;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    TFile *fTableFile;

    char sHistDir[500];
    char sHistName[500];
    char sHistNameL[500];
    char sHistNameLS[500];
    char sHistNameW[500];
    char sHistNameWS[500];
    int iZen[3];
    int iThr[3];

    vector<TH2F *> htempE;
    vector<TH2F *> htempL;
    vector<TH2F *> htempLS;
    vector<TH2F *> htempW;
    vector<TH2F *> htempWS;

    vector< vector<TH2F *> > hEnergy;
    vector< vector<TH2F *> > hLength;
    vector< vector<TH2F *> > hLengthSigma;
    vector< vector<TH2F *> > hWidth;
    vector< vector<TH2F *> > hWidthSigma;

    Float_t fZenith;
    float fThreshold;
    Int_t iZenith;
    Int_t iThreshold;
    Int_t iX;
    Int_t iY;
    float fEnergy1;
    float fEnergy2;
    float fEnergyRecon;

    float fLength;
    float fWidth;
    float fLengthSigma;
    float fWidthSigma;

    float fLength1;
    float fLength2;
    float fWidth1;
    float fWidth2;
    float fLengthSigma1;
    float fLengthSigma2;
    float fWidthSigma1;
    float fWidthSigma2;

    float RSW,RSL;

public:

    MEnergyTable(const char *name=NULL, const char *title=NULL);
    ~MEnergyTable();

    Int_t SetTableFile( const TString sTableFile );

    ClassDef(MEnergyTable, 0) // Task to estimate the energy

};

#endif








