#ifndef MARS_MDrsCalibrationTime
#define MARS_MDrsCalibrationTime

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_DrsCalib
#include "DrsCalib.h"
#endif

class TH1;

class MDrsCalibrationTime : public MParContainer, public DrsCalibrateTime
{
    std::vector<double> fDelays;

public:
    MDrsCalibrationTime(const char *name=0, const char *title=0)
    {
        fName  = name ? name : "MDrsCalibrationTime";
        fTitle = title ? title : "";
    }

    void InitSize(uint16_t channels, uint16_t samples)
    {
        //fDelays.clear();
        //fDelays.resize(channels);

        DrsCalibrateTime::InitSize(channels, samples);
    }

    void SetCalibration(const DrsCalibrateTime &cal)
    {
        *static_cast<DrsCalibrateTime*>(this) = cal;
    }

    bool SetDelays(const TH1 &cam);

    double GetOffset(int hw, int spos, float tm) const
    {
        return Offset(hw/9, fmod(tm+spos, 1024)) - Offset(hw/9, spos);
    }

    double GetDelay(int sw) const
    {
        return fDelays.size()==0 ? 0 : fDelays[sw];
    }

    ClassDef(MDrsCalibrationTime, 2) // A list of histograms storing the Fadc spektrum of one pixel
};

#endif

