\NeedsTeXFormat{LaTeX2e}  \ProvidesClass{newletter}

\RequirePackage{ifthen}
\newboolean{@german} \setboolean{@german}{false}
\DeclareOption{german}{\setboolean{@german}{true}}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\LoadClass[a4paper]{letter}

\newcommand{\@email}{}
\newcommand{\@institute}{}
\newcommand{\@street}{}
\newcommand{\@city}{}
\newcommand{\@tel}{}
\newcommand{\@foot}{}

\newcommand{\email}[1]{\renewcommand{\@email}{#1}}
\newcommand{\institute}[1]{\renewcommand{\@institute}{#1}}
\newcommand{\street}[1]{\renewcommand{\@street}{#1}}
\newcommand{\city}[1]{\renewcommand{\@city}{#1}}
\newcommand{\tel}[1]{\renewcommand{\@tel}{#1}}
\newcommand{\foot}[1]{\renewcommand{\@foot}{#1}}

\setlength{\textheight}{230mm}
\setlength{\textwidth}{162mm}
\setlength{\topmargin}{-50pt}
\setlength{\oddsidemargin}{0pt}
\setlength{\evensidemargin}{0pt}
\setlength{\headheight}{12pt}
\setlength{\headsep}{35pt}

\newlength{\leftfield}  \setlength{\leftfield}{118.5mm}
\newlength{\rightfield} \setlength{\rightfield}{42.5mm}

\DeclareFixedFont{\xviisf}{OT1}{cmss}{m}{n}{24.88}
\DeclareFixedFont{\xsf}{OT1}{cmss}{m}{n}{10} 
\DeclareFixedFont{\viiisf}{OT1}{cmss}{m}{n}{8}

\newcommand{\@place}{}

\renewcommand{\date}[1]{\def\@date{#1}}
\newcommand{\place}[1]{\renewcommand{\@place}{#1}}

\renewcommand{\ps@firstpage}{
  \setlength{\headheight}{41pt}
  \setlength{\headsep}{25pt}
  \renewcommand{\@oddhead}{
    \parbox{\textwidth}{
      \raisebox{-6pt}{\parbox[t]{\leftfield}{
        \xviisf\@institute}}
      \raisebox{4pt}{\parbox[t]{\rightfield}{
        \viiisf\baselineskip10pt\fromname\\\@street\\\@city}}\\[3pt]
      \rule{\textwidth}{1pt}}}
  \renewcommand{\@oddfoot}{  %\ifthenelse{ \equal{\@foot}{} }{}{ %
    \raisebox{-10pt}[0pt]{
      \parbox{\textwidth}{  
        \rule{\textwidth}{0.6pt}\\[2pt] 
        \mbox{}\hfill 
        \begin{tabular}[t]{p{5.5cm}}\@foot\end{tabular} }}} %}%
  \renewcommand{\@evenhead}{}
  \renewcommand{\@evenfoot}{}}

\renewcommand{\opening}[1]{
  \thispagestyle{firstpage}
  \vspace*{24pt}
  \parbox[t]{\leftfield}{
    \underline{\footnotesize\itshape\@institute , \@street , \@city}\\ 
    \parbox[b][3.5cm][c]{\leftfield}{\begin{quote}
       \bfseries\toname\\ \toaddress\end{quote}}}
  \raisebox{15pt}{\parbox[t]{\rightfield}{
    \large\fromname\\ \@street\\ \@city\\
    \ifthenelse{\equal{\@tel}{}}{}{\@tel\\} \par
    \normalsize\slshape
      \ifthenelse{\equal{\@email}{}}{}{email: \sffamily\@email\\}}}
  \par
  \rule{\textwidth}{0.6pt}
  \makebox[\leftfield][l]{#1}
  \makebox[\rightfield][r]{
    \ifthenelse{\equal{\@place}{}}{M\"unchen, den}{\@place, } \@date}
  \vspace{2\parskip}\par\nobreak}

\renewcommand{\@texttop}{}
