#ifndef MTASK_H
#define MTASK_H

#include "Magic.h"

#include "TOrdCollection.h"

class MParList;

class MTask : public TObject
{
private:
    char *fID;	   //! type of raw event which should be processed by this task

public:
    ~MTask()
      {
        if (fID)
	  delete fID;
      }

    virtual Bool_t PreProcess(MParList *pList);
    virtual Bool_t Process();
    virtual Bool_t PostProcess();
    
    void SetEventType(const char *evt);
    
    const char *GetEventType() const
    {
	return (const char*) fID;
    }

    ClassDef(MTask, 1)		// Base (abstract) class for a task
};

#endif
