#include <stdlib.h>


#include "MOctTest.h" 


MOctTest::MOctTest() 
{
  // default constructor  
} 

MOctTest::~MOctTest() 
{
  // default destructor  
} 


// ================================================================================
// ================================================================================
// ================================================================================
// ================================================================================


Bool_t MOctTest::PedAdcSpectra ( Char_t *inputfile ) 
{
  //
  //  
  
  printf ("PedAdcSpectra:: Analyse the file %s \n", inputfile ) ; 
  
  //   create a loop for this specific job. 
  
  MEvtLoop loop ; 
  
  // open input file
    
  MRootFile *fileIn = new MRootFile( inputfile );

  //   set up the ParameterList, 
  //   connect it to the loop
  
  MParList *plist = new MParList;
  loop.SetParList(plist);

  //   set up the TaskList for this program
  //   and connect it to the loop 
  
  MTaskList *tasks  = new MTaskList;
  tasks->SetEventType("PedTree") ;

  loop.SetTaskList(tasks);

  //    now set up all parameter(data) containers and put them 
  //    in the parameter list
  
  //    the buffer for the RawEvts, here for the Pedestals
  
  MObjBuffer *pedbuf = new MObjBuffer(new MRawEvt("PedTree"));  /* this buffer contains 
								 *  only one entry
								 */
  pedbuf->SetAsInput(fileIn);
  plist->AddToList(pedbuf);
  
  //  now it is neccessary to define the input stream, that means
  //  we set the input only to PedTree

  MInputStreamID  *inputStream = new MInputStreamID()  ;
  inputStream->SetEvtType("PedTree") ; 
  plist->AddToList(inputStream);
  
  //
  //     the data container for the histograms
  
  MHistosAdc *his = new MHistosAdc;
  
  plist->AddToList(his);
  //  his->SetAsOutput();
  // This tells the writer that this is an Output Container, which should
  // be written to a file ( not working yet)
  
  
  //   set up the tasks and add them to the list
  
  MParRead *readin = new MParRead;
  tasks->AddToList(readin, "PedTree");

  MAdcSpect *fillAdc = new MAdcSpect ("PedTree" ) ;
  tasks->AddToList(fillAdc, "PedTree");

  MShowSpect *showAdc = new MShowSpect () ;
  tasks->AddToList(showAdc, "PedTree");

  //    MParWrite *write = new MParWrite;
  //    tasks->AddToList(write);

  cout << endl;
  
  //
  //  Print the structure of the parameter list plist
  //
  tasks->Print();

  cout << endl;
  
  //////////////////////////////////////////////////////////////
  //
  //   call the event loop for 5000 Events
  //
  
  loop.Eventloop (50);
  
  cout << endl << "THE END." << endl ;
  
  

  return ( kTRUE ) ; 
} 

// ================================================================================
// ================================================================================
// ================================================================================
// ================================================================================


Bool_t MOctTest::CrAdcSpectra ( Char_t *inputfile ) 
{
  //
  //  

  printf ("MOctTest::CrAdcSpectra -- Analyse the file %s \n", inputfile ) ; 
  //   create a loop for this specific job. 
  
  MEvtLoop loop ; 
  
  // open input file
    
  MRootFile *fileIn = new MRootFile( inputfile );

  //   set up the ParameterList, 
  //   connect it to the loop
  
  MParList *plist = new MParList;
  loop.SetParList(plist);

  //   set up the TaskList for this program
  //   and connect it to the loop 
  
  MTaskList *tasks  = new MTaskList;
  loop.SetTaskList(tasks);

  //    now set up all parameter(data) containers and put them 
  //    in the parameter list
  
  //    the buffer for the RawEvts, here for the Pedestals
  
  MObjBuffer *pedbuf = new MObjBuffer(new MRawEvt("EvtTree"));  /* this buffer contains 
								 *  only one entry
								 */
  pedbuf->SetAsInput(fileIn);
  plist->AddToList(pedbuf);
    
  //  now it is neccessary to define the input stream, that means
  //  we set the input only to EvtTree

  MInputStreamID  *inputStream = new MInputStreamID()  ;
  inputStream->SetEvtType("EvtTree") ; 
  plist->AddToList(inputStream);

  //     the data container for the histograms
  
  MHistosAdc *his = new MHistosAdc;
  
  plist->AddToList(his);
  //  his->SetAsOutput();
  // This tells the writer that this is an Output Container, which should
  // be written to a file ( not working yet)
  
  
  //   set up the tasks and add them to the list
  
  MParRead *readin = new MParRead;
  tasks->AddToList(readin, "EvtTree");

  MAdcSpect *fillAdc = new MAdcSpect ("EvtTree" ) ;
  tasks->AddToList(fillAdc, "EvtTree");

  MShowSpect *showAdc = new MShowSpect () ;
  tasks->AddToList(showAdc, "PedTree");

  //    MParWrite *write = new MParWrite;
  //    tasks->AddToList(write);

  cout << endl;
  
  //
  //  Print the structure of the parameter list plist
  //
  tasks->Print();

  cout << endl;
  
  //////////////////////////////////////////////////////////////
  //
  //   call the event loop for 5000 Events
  //
  
  loop.Eventloop (5000);
  
  cout << endl << "THE END." << endl ;
  
  

  return ( kTRUE ) ; 
} 
