///////////////////////////////////////////////////////////////////////
//
// MParList
//
// This class contains a list of different Parameter and Data
// Containers. 
//
// You can add every parameter Container (Named object) to the
// instance and access it from somewhere else via its Name.
//
///////////////////////////////////////////////////////////////////////

#include "MParList.h"

#include <TNamed.h>

#include "MParContainer.h"

ClassImp(MParList)

MParList::MParList() : fNext(NULL)
{
  //
  //  default constructor 
  //  creates an empty list 
  //

}

MParList::MParList(MParList &ts)
{
  //
  // copy constructor 
  //

  fContainer.AddAll(&ts.fContainer);
}


Bool_t MParList::AddToList(MParContainer *obj, MParContainer *where)
{
  // 
  //  Add an Container to the list.
  // 
  //  If 'where' is given, the object will be added after this.
  //
  
  //
  //  check if the object (you want to add) exists
  //
  if (!obj) return kTRUE;

  cout << "Adding " << obj->GetName() << " to " << GetName() << "... " << flush;
  //
  //  check if it is in the list yet
  //
  if (fContainer.FindObject(obj))
  {
      cout << "WARNING: MParList::add: Container already added" << endl;
      return kTRUE;
  }

  //
  //  check if you want to add the new parameter container somewhere 
  //  special (in that case you specify "where") 
  //  
  if (where)
  {
      if (!fContainer.FindObject(where))
      {
          cout << "ERROR: MParList::add: Cannot find parameter container after which the new one should be added!" << endl;
          return kFALSE;
      }
  }

  fContainer.Add(obj);
  cout << "Done." << endl;

  return kTRUE;
}

TObject *MParList::FindObject(const char *name) const
{
    //
    //  Find an object in the list.
    //  'name' is the name of the object you are searching for.
    //
    return (TObject*)fContainer.FindObject(name);
}


void MParList::Print(Option_t *t)
{
    //
    //   print some information about the current status of MParList
    //
    cout << "ParList: " << this->GetName() << " <" << this->GetTitle() << ">" << endl;
    cout << endl;
}

