///////////////////////////////////////////////////////////////////////
//
//   MTask
// 
//   Base class for all tasks which can perfomed in a tasklist
//   For each event processed in the eventloop all the different
//   tasks in the tasklist will be processed.
//  
//   So all tasks must inherit from this baseclass. 
//
//   The data member fEventType is used to indicate the type of events
//   that are process by this task. There are the following different
//   event types: 
//
//   This is the type of task for which this task should be processed
//   taskType-bits: 7 6 5 4 3 2 1 0
//   0 DATA_EVT
//   1 CALIBRATION_EVT
//   ? etc. etc. 
//
//   Inside this abstract class, there are three fundamental function: 
//
//   - PreProcess() :  executed before the eventloop starts. Here you 
//                     can initiate different things, open files, etc. 
//
//   - Process()    :  executed for each event in the eventloop. Do in 
//                     one task after the other (as the occur in the 
//                     tasklist) the action of one task. 
//  
//   - PostProcess():  executed after the eventloop. Here you can close 
//                     output files, start display of the run parameter, 
//                     etc. 
//  
//  
///////////////////////////////////////////////////////////////////////

#include "MTask.h"

#include <string.h>
#include <iostream.h>

ClassImp(MTask)

Bool_t MTask::PreProcess( MParList *pList )
{
  //
  // This is processed before the eventloop starts
  // 
  // It is the job of the PreProcess to connect the tasks
  // with the right container in the parameter list. 
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE; 
}


Bool_t MTask::Process()
{
  //
  // This is processed for every event in the eventloop 
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE;
}

Bool_t MTask::PostProcess()
{
  //
  // This is processed after the eventloop starts
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE;
}


