%% File: icrc.cls
%% =============================================
%% IMPORTANT NOTICE:
%% See the copyright conditions below.
%% =============================================
%% EGS LaTeX2e Class file
%% ---------------------------------
%% LaTeX2e class file for contributions to ICRC
%% ---------------------------------
%% Author:
%% Dieter Schmitt
%% Copernicus Gesellschaft
%% Max-Planck-Str. 13
%% D-37191 Katlenburg-Lindau
%% Germany
%%
%% based on egs.cls by Patrick W. Daly
%%
%% Email:      egs@copernicus.org
%% Internet:   http://www.copernicus.org/EGS/EGS.html
%%
%% This consists of several modules, each with its separate copywrite
%% The modules that are specific to EGS publications are
%%        Copyright (C) 1994-2000 Copernicus Gesellschaft
%%
%% The entire package is available from
%%        http://www.copernicus.org/COPERNICUS/latex/latex.htm

\NeedsTeXFormat{LaTeX2e}[1994/06/01]
\ProvidesClass{icrc}
          [2000/11/22 (DS)]

%  This is a LaTeX2e class file, to be invoked as
%     \documentclass{isss}
%  It requires the local files
%     article.cls   size10.clo    fleqn.clo

\newif\if@headers \@headerstrue
\DeclareOption{fleqn}{\relax}
\DeclareOption{twoside}{\relax}
\DeclareOption{twocolumn}{\relax}
\DeclareOption{titlepage}{\relax}
\DeclareOption{headers}{\@headerstrue}
\DeclareOption{noheaders}{\@headersfalse}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[fleqn,a4paper]{article}
\paperheight=277mm\paperwidth=210mm
\IfFileExists{times.sty}{\RequirePackage{times}}{}

\@twosidefalse

\renewcommand{\vec}[1]{\ensuremath{\mathchoice{\mbox{\boldmath$\displaystyle#1$}}
                                   {\mbox{\boldmath$\textstyle#1$}}
                                   {\mbox{\boldmath$\scriptstyle#1$}}
                                   {\mbox{\boldmath$\scriptscriptstyle#1$}}}}
                                   
\def\refname{References}
\def\figurename{Fig.}
\def\tablename{Table}
\def\fnum@figure{\figurename~\thefigure}
\def\fnum@table{\tablename~\thetable}

\def\abstractname{Abstract}

\def\acknowname{Acknowledgement}
\def\acknowsname{Acknowledgements}

\def\@normalsize{\@setsize\normalsize{12pt}\xpt\@xpt
\abovedisplayskip 10\p@ plus2\p@ minus5\p@
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip  \z@ plus3\p@
\belowdisplayshortskip  6\p@ plus3\p@ minus3\p@
\let\@listi\@listI}

\def\small{\@setsize\small{11pt}\ixpt\@ixpt
\abovedisplayskip 8.5\p@ plus3\p@ minus4\p@
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus2\p@
\belowdisplayshortskip 4\p@ plus2\p@ minus2\p@
\def\@listi{\leftmargin\leftmargini
\topsep 4\p@ plus2\p@ minus2\p@\parsep 2\p@ plus\p@ minus\p@
\itemsep \parsep}}

\let\footnotesize=\small

\def\scriptsize{\@setsize\scriptsize{8pt}\viipt\@viipt}
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\pt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}

\normalsize
\oddsidemargin  -0.9cm
\evensidemargin -0.9cm
\topmargin -3.0cm
\headheight 2cm
\headsep 0.5cm
\topskip = 12pt
\footskip 30pt

\textwidth 17.7cm
\textheight = 56\baselineskip

\advance\textheight by \topskip
\columnsep 0.7cm
\columnseprule 0pt

\parindent 1em
\parskip 0pt plus 1pt

\def\section{\@startsection {section}{1}{\z@}{-2em plus-1ex minus
    -.2ex}{1em plus.2ex}{\reset@font\normalsize
             \bfseries
}}
\def\subsection{\@startsection{subsection}{2}{\z@}{-1em plus-0.25ex
    minus-.2ex}{1em plus.2ex}{\reset@font\normalsize
             \rmfamily
}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-1em plus
    -0.25ex minus-.2ex}{1em plus.2ex}{\reset@font\normalsize
             \rmfamily
}}

\let\paragraph=\subsubsection
\let\subparagraph=\paragraph

\@ifundefined{reset@font}{\let\reset@font=\relax}{}
\setcounter{secnumdepth}{3}
\def\desfont{\itshape}
\def\descriptionlabel#1{\hspace\labelsep \desfont #1.}
\def\description{\list{}{\labelwidth\z@ \leftmargin\z@ \itemindent-\leftmargin
       \let\makelabel\descriptionlabel\reset@font\small}}
\let\enddescription\endlist

\setcounter{topnumber}{1}
\def\topfraction{.7}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.3}
\setcounter{totalnumber}{3}
\def\textfraction{0}
\def\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}

\long\def\@makecaption#1#2{%
   \vskip 10\p@
     {\reset@font\small{\bf #1.} #2\par}}

\long\def\@makenarrowcap#1#2{\hfill\vbox to \z@{\hsize=5cm \vss
     \reset@font\small{\bf #1.} #2\par\null}}
\def\figbox{\@ifstar{\let\egsbox\makebox\@figbox}
  {\let\egsbox\framebox\@figbox}}
\def\@figbox#1#2#3{\setbox\@tempboxa=\hbox{%
  \if!#1!\egsbox{#3}\else
  \egsbox[#1][c]{\if!#2!#3\else\@tempdima#2\relax
  \divide\@tempdima by2\relax
  \advance\@tempdima by-\fboxsep \advance\@tempdima by-\fboxrule
  \vrule\@height\@tempdima\@depth\@tempdima\@width\z@
  \vbox to \z@{\vss\hbox{#3}\vss}\fi}\fi}%
  \@tempdima=\hsize \advance\@tempdima by-\wd\@tempboxa
  \box\@tempboxa
  \ifdim\@tempdima>5.5cm \let\@makecaption=\@makenarrowcap\fi
  }
\let\@oxfloat=\@xfloat
\def\@xfloat#1[#2]{\@oxfloat#1[#2]\small}

\leftmargini 2em
\leftmarginii 1.75em
\leftmarginiii 1.5em
\leftmarginiv 1em
\leftmarginv .5em
\leftmarginvi .5em

\def\labelitemi{\bf --}
\def\labelitemii{\bf --}
\def\labelitemiii{$\m@th\bullet$}
\def\labelitemiv{$\m@th\cdot$}
\def\maketitle{\setcounter{Maxaffil}{1}

\if@headers\setcounter{page}{\@fpage}
\thispagestyle{default}
%\xdef\@temp{\@journal}
%\ifx\@temp\ISSS6\thispagestyle{isss6}\fi
\fi

\setcounter{footnote}{0}
\begingroup
\def\@thanks{}\parindent=0pt

\twocolumn[
   {\begin{minipage}[b][\@tithei][s]{\hsize}
      \null\vfil
      \begin{minipage}{\hsize}
          \raggedright
          \let\footnotesize\normalsize
          \let\footnoterule\relax
          \def\thefootnote{\fnsymbol{footnote}}%
          \def\@mpfn{footnote}%
          \let\thempfn=\thefootnote
          \renewcommand\@makefntext[1]{%
          \parindent 1em \noindent
          \@makefnmark##1}
          {\LARGE\bfseries \@title\par}
          \vspace{10pt}
          {\normalsize
          \renewcommand{\Authfont}{\bfseries}%
          \renewcommand{\Affilfont}{\mdseries}%
          \setlength{\affilsep}{4pt}%
          \baselineskip 15pt
          \let\and=\sw@and
          \begin{minipage}[t]{\hsize}\flushleft\baselineskip=12pt%
              \@author
          \end{minipage}\par}%
         \@thanks
      \end{minipage}
      \vspace{20pt} 
   \end{minipage}
}]

\renewcommand\@makefntext[1]{\parindent 1em \noindent ##1}%
\let\footnotesize\normalsize
 
\if!\@corresp!\else
\footnotetext{\textit{Correspondence to:} \@corresp}%
\fi
\endgroup

\setcounter{footnote}{0}
\let\thanks\relax
\gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\maketitle\relax
}

\renewcommand\and{\@centercr}
\newcommand\sw@and{\end{minipage}\\[1em]\begin{minipage}[t]{\hsize}%
  \flushleft\baselineskip12pt}
%\def\journal#1{\def\@journal{#1}}
%\let\booktitle=\journal
%   \def\@journal{???}


\def\correspondence#1{\def\@corresp{#1} \def\offsets##1{\def\@offsets{##1}}}
  \def\@corresp{}

\def\pubyear#1{\def\@pyear{#1}} \def\@pyear{2001}
\def\titleheight#1{\def\@tithei{#1}} \def\@tithei{7.5cm}

\def\firstpage#1{\def\@fpage{#1}} \def\@fpage{1}
\def\runninghead#1{\def\@runhd{}} \def\@runhd{}
%\def\lastpage@putlabel{\addtocounter{page}{-1}
%   \immediate\write\@auxout{\string
%   \newlabel{LastPage}{{}{\thepage}}}
%   \addtocounter{page}{1}}
%\AtEndDocument{\clearpage\lastpage@putlabel}
%\def\@lpage{\pageref{LastPage}}

\renewenvironment{abstract}{
      \reset@font\normalsize\par\noindent
        {\bfseries \abstractname.}
         \ignorespaces
}{\newline\null\par\hrule}
  
\newenvironment{acknowledgements}{\begin{description}\item[\acknowsname]}
    {\end{description}}
\newenvironment{acknowledgement}{\begin{description}\item[\acknowname]}
    {\end{description}}
    
\def\ps@runninghead{\let\@mkboth\@gobbletwo
%\def\@oddhead{\@runhd\hfil\makebox[\z@][r]{\thepage}}
%\def\@evenhead{\makebox[\z@][l]{\thepage}\hfil\@runhd}
  \def\@oddhead{\hfil\thepage\hfil}
  \def\@evenhead{\hfil\thepage\hfil}
  \def\@oddfoot{}\def\@evenfoot{}}
  
\def\ps@default{\let\@mkboth\@gobbletwo
  \def\@oddhead{Proceedings of ICRC\ \@pyear:\
    \@fpage\ \copyright\ Copernicus Gesellschaft 2001
    \hfil\scalebox{0.8}[1.0]{\@icrclogo}}
  \def\@oddfoot{}}

\def\logo@font{\fontfamily{\sfdefault}\fontseries{\seriesdefault}}
\def\logo@width{18.75pc}

\def\@icrclogo{\parbox[t][\z@][t]{\logo@width}
  {\vspace{-.7\baselineskip}
  \rule{\linewidth}{1\p@}\\\logo@font
    \fontsize{46}{3}\selectfont
    ICRC\ 2001\par
    \rule{\linewidth}{1\p@}}}
    
\flushbottom

\pagenumbering{arabic}
\flushbottom

\if@headers\@twosidetrue\ps@runninghead
   \else\ps@cameraready\fi

\newcommand\fncomma{\textsuperscript{,}}
\AtBeginDocument{\mathindent\z@}

%% Copyright 1997-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{authblk}
          [1999/02/23 1.2 (PWD)]
%% authblk coding copyright (C) 1997 Patrick W. Daly
\newcommand\Authfont{\normalfont}
\newcommand\Affilfont{\normalfont}
\newcommand\Authsep{, }
\newcommand\Authands{, and }
\newcommand\Authand{ and }
\newlength{\affilsep}\setlength{\affilsep}{1em}
\newlength{\@affilsep}
\newcounter{Maxaffil}
\setcounter{Maxaffil}{2}
\newcounter{authors}
\newcounter{affil}
\newif\ifnewaffil \newaffiltrue
\newcommand\AB@authnote[1]{\textsuperscript{\normalfont#1}}
\newcommand\AB@affilnote[1]{\textsuperscript{\normalfont#1}}
\providecommand\textsuperscript[1]{$^{#1}$}
\newcommand\AB@blk@and{\protect\Authfont\protect\AB@setsep}
\newcommand\AB@pand{\protect\and \protect\Authfont \protect\AB@setsep}
\@namedef{@sep1}{}
\@namedef{@sep2}{\Authand}
\newcommand\AB@affilsep{\protect\Affilfont}
\newcommand\AB@affilsepx{\protect\\\protect\Affilfont}
\newcommand\AB@setsep{\setlength{\@affilsep}{\affilsep}}
\newcommand\AB@resetsep{\setlength{\@affilsep}{\z@}}
\newcommand\AB@authlist{}
\newcommand\AB@affillist{}
\newcommand\AB@authors{}
\newcommand\AB@empty{}
\xdef\AB@author{\noexpand\AB@blk@and\@author}
\renewcommand\author[2][]%
      {\ifnewaffil\addtocounter{affil}{1}%
       \edef\AB@thenote{\arabic{affil}}\fi
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \ifnum\value{authors}>1\relax
      \@namedef{@sep\number\c@authors}{\Authsep}\fi
      \addtocounter{authors}{1}%
      \begingroup
          \let\protect\@unexpandable@protect \let\and\AB@pand
          \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
         \@temptokena=\expandafter{\AB@authors}%
         {\def\\{\protect\\[\@affilsep]\protect\Affilfont
              \protect\AB@resetsep}%
              \xdef\AB@author{\AB@blk@and#2}%
       \ifnewaffil\gdef\AB@las{}\gdef\AB@lasx{\protect\Authand}\gdef\AB@as{}%
           \xdef\AB@authors{\the\@temptokena\AB@blk@and}%
       \else
          \xdef\AB@authors{\the\@temptokena\AB@as\AB@au@str}%
          \global\let\AB@las\AB@lasx\gdef\AB@lasx{\protect\Authands}%
          \gdef\AB@as{\Authsep}%
       \fi
       \gdef\AB@au@str{#2}}%
         \@temptokena=\expandafter{\AB@authlist}%
         \let\\=\authorcr
         \xdef\AB@authlist{\the\@temptokena
           \protect\@nameuse{@sep\number\c@authors}%
           \protect\Authfont#2\AB@authnote{\AB@note}}%
      \endgroup
      \ifnum\value{authors}>2\relax
      \@namedef{@sep\number\c@authors}{\Authands}\fi
      \newaffilfalse
}
\newcommand\authorcr{\protect\\ \protect\Authfont \protect\AB@setsep}%
\newcommand\affil[2][]%
   {\newaffiltrue\let\AB@blk@and\AB@pand
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \begingroup
        \let\protect\@unexpandable@protect
        \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
        \@temptokena=\expandafter{\AB@authors}%
        {\def\\{\protect\\\protect\Affilfont}\xdef\AB@temp{#2}}%
         \xdef\AB@authors{\the\@temptokena\AB@las\AB@au@str
         \protect\\[\affilsep]\protect\Affilfont\AB@temp}%
         \gdef\AB@las{}\gdef\AB@au@str{}%
        {\def\\{, \ignorespaces}\xdef\AB@temp{#2}}%
        \@temptokena=\expandafter{\AB@affillist}%
        \xdef\AB@affillist{\the\@temptokena \AB@affilsep
          \AB@affilnote{\AB@note}\protect\Affilfont\AB@temp}%
      \endgroup
       \let\AB@affilsep\AB@affilsepx
}
\def\@author{}
\renewcommand\@author{\ifx\AB@affillist\AB@empty\AB@author\else
      \ifnum\value{affil}>\value{Maxaffil}\def\rlap##1{##1}%
    \AB@authlist\\[\affilsep]\AB@affillist
    \else  \AB@authors\fi\fi}
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{appendix}
           [1999/02/23 2.1 (PWD)]
\@ifundefined{iffigcaps}{}
  {\PackageWarningNoLine{appendix}
     {***********************************\MessageBreak
      This package read in after `figcaps'\MessageBreak
      There could be problems with sublabelled\MessageBreak
      figure and table numbers.\MessageBreak
      ***********************************}}
\providecommand{\appendixname}{Appendix}
\let\orisection=\section
\let\theolds=\thesection
\let\theoldss=\thesubsection
\def\appendix{\par
  \setcounter{section}{0}
  \setcounter{subsection}{0}
  \def\thesection{\Alph{section}}
  \def\thesubsection{\thesection\arabic{subsection}}
  \setcounter{secnumdepth}{4}
  \@addtoreset{equation}{section}
  \setcounter{equation}{0}
  \def\theequation{\thesection\arabic{equation}}
  \@addtoreset{figure}{section}
  \setcounter{figure}{0}
  \def\thefigure{\thesection\arabic{figure}}
  \@addtoreset{table}{section}
  \def\thetable{\thesection\arabic{table}}
  \setcounter{table}{0}
  \def\@Alph##1{\ifcase##1A\or A\or B\or C\or D\else\@Ialph{##1}\fi}
  \def\section{\@startsection {section}{1}{\z@}{-2em plus
    -1ex minus-.2ex}{1em plus.2ex}{\reset@font
       \normalsize
    \bfseries\noindent \appendixname~}}
}
\def\noappendix{\setcounter{secnumdepth}{0}
  \global\let\section=\orisection
  \global\let\thesection=\theolds
  \global\let\thesubsection=\theoldss
}
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{figcaps}
        [1999/02/23 4.7 (PWD)]
\@ifundefined{chapter}{}{%
    \PackageError{figcaps}
     {`figcaps' may only be used with article-like classes}
     {There is no help. You just cannot use `figcaps'}}
\newif\iffigcaps \figcapstrue
\newif\iffigmark \figmarkfalse
\newif\if@figpage \@figpagefalse
\@ifundefined{figurecapname}{\def\figurecapname{Figure Captions}}{}
\@ifundefined{tablepagename}{\def\tablepagename{Tables}}{}
\@ifundefined{figurepagename}{\def\figurepagename{Figures}}{}
\begingroup
  \catcode `|=0 \catcode `[= 1
  \catcode`]=2 \catcode `\{=12 \catcode `\}=12
  \catcode`\^^M=13 \catcode`\\=12 %
|long|gdef|@vfig#1\end{figure}[|def|@term[\end{figure}]%
          |expandafter|writelof#1^^M\end{figure}^^M|end[figure]]%
|long|gdef|@vsfig#1\end{figure*}[|def|@term[\end{figure*}]%
          |expandafter|writelof#1^^M\end{figure*}^^M|end[figure*]]%
|long|gdef|@vtab#1\end{table}[|def|@term[\end{table}]%
          |expandafter|writelot#1^^M\end{table}^^M|end[table]]%
|long|gdef|@vstab#1\end{table*}[|def|@term[\end{table*}]%
          |expandafter|writelot#1^^M\end{table*}^^M|end[table*]]%
|long|gdef|@fcaponly#1\caption[|endgroup|@fcaption]%
|long|gdef|@feject#1\end{figure}[|end[figure]]%
  |endgroup
\long\def\FC@writefile#1#2{\@ifundefined{tf@#1}{}{%
  \immediate\write\csname tf@#1\endcsname{#2}}}
\def\lof{lof} \def\lot{lot}

{\catcode`\^^M=13%
  \long\gdef\writelof#1^^M{\def\@tempb{#1}%
      \ifx\@tempb\@term\let\@tempa\relax\else
      \if@filesw\FC@writefile{pof}{#1}\fi\let\@tempa\writelof\fi \@tempa}
  \long\gdef\writelot#1^^M{\def\@tempb{#1}%
      \ifx\@tempb\@term\let\@tempa\relax\else
      \if@filesw\FC@writefile{pot}{#1}\fi\let\@tempa\writelot\fi \@tempa}
}
\def\@fcaption{\refstepcounter\@captype \@ifnextchar[{\@@fcapopt}{\@@fcap}}
\def\@@fcapopt[#1]#2{\@caption\@captype[]{#2}\begingroup\set@literal\@feject}
\def\@@fcap#1{\@caption\@captype[]{#1}\begingroup\set@literal\@feject}
\def\figcapson{\figcapstrue}
\def\figcapsoff{\figcapsfalse}
\def\figmarkon{\figmarktrue}
\def\figmarkoff{\figmarkfalse}
\def\figure{\iffigcaps \let\@tempb=\@zfigure \else \let\@tempb=\@float\fi
  \@tempb{figure}}
\def\@zfigure#1{\begingroup\set@literal\@ifnextchar[{\@figure}{\@figure[]}}
\def\@figure[#1]{\@ifundefined{tf@pof}{\newwrite\tf@pof
     \if@filesw\immediate\openout\tf@pof\jobname.\lof\relax
     \ifFC@appendix\FC@writefile{pof}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{figure}\iffigmark\marginpar{\fbox{\fnum@figure}}\fi
  \def\@captype{figure}\if@filesw\FC@writefile{pof}{\string\begin{figure}}\fi
  \@vfig}

\def\endfigure{\iffigcaps
    \endgroup\if@filesw\FC@writefile{pof}{\string\end{figure}}\fi\else
    \end@float\fi}

\@namedef{figure*}{\iffigcaps \let\@tempb=\@zsfigure \else
  \let\@tempb=\@dblfloat\fi \@tempb{figure}}
\def\@zsfigure#1{\begingroup\set@literal\@ifnextchar[{\@sfigure}{\@sfigure[]}}
\def\@sfigure[#1]{\@ifundefined{tf@pof}{\newwrite\tf@pof
     \if@filesw\immediate\openout\tf@pof\jobname.\lof\relax
     \ifFC@appendix\FC@writefile{pof}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{figure}\iffigmark\marginpar{\fbox{\fnum@figure}}\fi
  \def\@captype{figure}\if@filesw\FC@writefile{pof}{\string\begin{figure}}\fi
  \@vsfig}

\@namedef{endfigure*}{\iffigcaps\endfigure\else\end@dblfloat\fi}
\def\table{\iffigcaps \let\@tempb=\@ztable \else \let\@tempb=\@float\fi
  \@tempb{table}}
\def\@ztable#1{\begingroup\set@literal\@ifnextchar[{\@table}{\@table[]}}
\def\@table[#1]{\@ifundefined{tf@pot}{\newwrite\tf@pot
     \if@filesw\immediate\openout\tf@pot\jobname.\lot\relax
     \ifFC@appendix\FC@writefile{pot}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{table}\iffigmark\marginpar{\fbox{\fnum@table}}\fi
  \def\@captype{table}\if@filesw\FC@writefile{pot}{\string\begin{table}}\fi
  \@vtab}

\def\endtable{\iffigcaps
   \endgroup\if@filesw\FC@writefile{pot}{\string\end{table}}\fi\else
   \end@float\fi}

\@namedef{table*}{\iffigcaps \let\@tempb=\@zstable \else
  \let\@tempb=\@dblfloat\fi \@tempb{table}}
\def\@zstable#1{\begingroup\set@literal\@ifnextchar[{\@stable}{\@stable[]}}
\def\@stable[#1]{\@ifundefined{tf@pot}{\newwrite\tf@pot
     \if@filesw\immediate\openout\tf@pot\jobname.\lot\relax
     \ifFC@appendix\FC@writefile{pot}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{table}\iffigmark\marginpar{\fbox{\fnum@table}}\fi
  \def\@captype{table}\if@filesw\FC@writefile{pot}
    {\string\begin{table}}%
    \fi\@vstab}

\@namedef{endtable*}{\iffigcaps\endtable\else
   \end@dblfloat\fi}
\def\tableofcontents{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\tableofcontents\space command}}
\def\listoffigures{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\listoffigures\space command}}
\def\listoftables{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\listoftables\space command}}
\def\addtocontents#1#2{\relax}
\def\addcontentsline#1#2#3{\relax}
{\catcode`\^^M=\active \gdef\cr@relax{\catcode`\^^M=\active \let^^M=\relax}}
\def\set@literal{\cr@relax \let\do\@makeother\dospecials}
\def\@figurecaps{\@ifundefined{tf@pof}{}{\if@filesw
  \immediate\closeout\tf@pof\fi
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \parindent\z@
  \reset@figtab\clearpage\section*{\figurecapname}\vspace{1cm}%
    \@mkboth{\uppercase{\figurecapname}}{\uppercase{\figurecapname}}%
    \addcontentsline{toc}{section}{\figurecapname}%
  \def\figure{\def\addcontentsline####1####2####3{}%
    \def\@captype{figure}%
    \begingroup\set@literal\@fcaponly
   }\def\endfigure{\endgroup\bigskip}%
  {\let\@makecaption=\@makefcaption
  \@input{\jobname.\lof}}%
  \clearpage}}%
\def\@tablepage{\@ifundefined{tf@pot}{}{\if@filesw
  \immediate\closeout\tf@pot\fi
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \parindent\z@
  \reset@figtab\clearpage\section*{\tablepagename}
    \@mkboth{\uppercase{\tablepagename}}{\uppercase{\tablepagename}}%
   \def\table{\def\@captype{table}\vbox\bgroup
    \small
   }\def\endtable{\egroup\bigskip}%
  \@input{\jobname.\lot}
  \clearpage}}
\def\printfigures{\@figpagetrue}
\def\@figurepage{\if@figpage\@ifundefined{tf@pof}{}{%
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \reset@figtab\clearpage\section*{\figurepagename}%
  \@mkboth{\uppercase{\figurepagename}}{\uppercase{\figurepagename}}%
  \begingroup
  \def\figure{\def\@captype{figure}\vbox\bgroup}\def\endfigure{\egroup
    \vspace{20pt}}%
  \def\label##1{}%
  \@input{\jobname.\lof}\newpage\endgroup}\fi}
\def\reset@figtab{%
  \setcounter{figure}{0}\setcounter{table}{0}
}
\AtEndDocument{\iffigcaps\@tablepage\@figurecaps\@figurepage\fi}
\let\@appendix=\appendix
\newif\ifFC@appendix \FC@appendixfalse
\def\appendix{\FC@appendixtrue
  \@ifundefined{tf@pof}{}{\if@filesw\FC@writefile{pof}{\string\doappendix}\fi}%
  \@ifundefined{tf@pot}{}{\if@filesw\FC@writefile{pot}{\string\doappendix}\fi}%
  \global\let\@section=\section
  \doappendix
  \let\@@section=\section
  \def\section{%
    \@ifundefined{tf@pof}{}{\if@filesw\FC@writefile{pof}{\string
        \stepcounter{section}}\fi}%
    \@ifundefined{tf@pot}{}{\if@filesw\FC@writefile{pot}{\string
        \stepcounter{section}}\fi}%
    \@@section}
  \global\let\reset@figtab=\@unappendix}
\def\doappendix{%
  \global\let\@thefigure=\thefigure
  \global\let\@thetable=\thetable
  \global\let\@cl@section=\cl@section
  \@appendix
}
\def\@unappendix{\FC@appendixfalse
  \setcounter{figure}{0}\setcounter{table}{0}
  \let\thefigure=\@thefigure
  \let\thetable=\@thetable
  \let\cl@section=\@cl@section
  \let\section=\@section
}
\let\@makefcaption=\@makecaption
%\if@draft\figcapstrue\else\figcapsfalse\fi
\figcapsfalse
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{natbib}
        [1999/05/28 7.0 (PWD)]
\def\NAT@sort{0}
\newcommand\NAT@open{(} \newcommand\NAT@close{)}
\newcommand\NAT@sep{;} \newcommand\NAT@cmt{, }
\newcommand\NAT@aysep{,} \newcommand\NAT@yrsep{,}
\def\NAT@nmfmt#1{{\NAT@up#1}}
\renewcommand\@cite%
    [3]{\ifNAT@swa\NAT@@open\if*#2*\else#2\ \fi
        #1\if*#3*\else\NAT@cmt#3\fi\NAT@@close\else#1\fi\endgroup}
\providecommand\@firstofone[1]{#1}
\let\citenumfont=\relax
\def\@citex%
  [#1][#2]#3{%
  \NAT@sort@cites{#3}%
  \let\@citea\@empty
  \@cite{\let\NAT@nm\@empty\let\NAT@year\@empty
    \@for\@citeb:=\NAT@cite@list\do
    {\edef\@citeb{\expandafter\@firstofone\@citeb}%
     \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
     \@ifundefined{b@\@citeb\@extra@b@citeb}{\@citea%
       {\reset@font\bfseries ?}\NAT@citeundefined
                 \PackageWarning{natbib}%
       {Citation `\@citeb' on page \thepage \space undefined}\def\NAT@date{}}%
     {\let\NAT@last@nm=\NAT@nm\let\NAT@last@yr=\NAT@year
     \NAT@parse{\@citeb}%
     \ifNAT@full\let\NAT@nm\NAT@all@names\else
       \let\NAT@nm\NAT@name\fi
     \ifNAT@swa\ifcase\NAT@ctype
       \if\relax\NAT@date\relax
         \@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@nmfmt{\NAT@nm}\NAT@date\hyper@natlinkend
       \else
         \ifx\NAT@last@nm\NAT@nm\NAT@yrsep
            \ifx\NAT@last@yr\NAT@year
              \hyper@natlinkstart{\@citeb\@extra@b@citeb}\NAT@exlab
              \hyper@natlinkend
            \else\unskip\
              \hyper@natlinkstart{\@citeb\@extra@b@citeb}\NAT@date
              \hyper@natlinkend
            \fi
         \else\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
           \NAT@nmfmt{\NAT@nm}%
           \hyper@natlinkbreak{\NAT@aysep\ }{\@citeb\@extra@b@citeb}%
           \NAT@date\hyper@natlinkend
         \fi
       \fi
     \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@nmfmt{\NAT@nm}\hyper@natlinkend
     \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@date\hyper@natlinkend
     \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@alias\hyper@natlinkend
     \fi \def\@citea{\NAT@sep\ }%
     \else\ifcase\NAT@ctype
        \if\relax\NAT@date\relax
          \@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
          \NAT@nmfmt{\NAT@nm}\hyper@natlinkend
        \else
         \ifx\NAT@last@nm\NAT@nm\NAT@yrsep
            \ifx\NAT@last@yr\NAT@year
              \hyper@natlinkstart{\@citeb\@extra@b@citeb}\NAT@exlab
              \hyper@natlinkend
            \else\unskip\
              \hyper@natlinkstart{\@citeb\@extra@b@citeb}\NAT@date
              \hyper@natlinkend
            \fi
         \else\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
           \NAT@nmfmt{\NAT@nm}%
           \hyper@natlinkbreak{\ \NAT@@open\if*#1*\else#1\ \fi}%
              {\@citeb\@extra@b@citeb}%
           \NAT@date\hyper@natlinkend\fi
        \fi
       \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@nmfmt{\NAT@nm}\hyper@natlinkend
       \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@date\hyper@natlinkend
       \or\@citea\hyper@natlinkstart{\@citeb\@extra@b@citeb}%
         \NAT@alias\hyper@natlinkend
       \fi \if\relax\NAT@date\relax\def\@citea{\NAT@sep\ }%
           \else\def\@citea{\NAT@@close\NAT@sep\ }\fi
     \fi
     }}\ifNAT@swa\else\if*#2*\else\NAT@cmt#2\fi
     \if\relax\NAT@date\relax\else\NAT@@close\fi\fi}{#1}{#2}}
\newif\ifNAT@par \NAT@partrue
\newcommand\NAT@@open{\ifNAT@par\NAT@open\fi}
\newcommand\NAT@@close{\ifNAT@par\NAT@close\fi}
\newcommand\NAT@alias{\@ifundefined{al@\@citeb\@extra@b@citeb}{%
  {\reset@font\bfseries(alias?)}\PackageWarning{natbib}
  {Alias undefined for citation `\@citeb'
  \MessageBreak on page \thepage}}{\@nameuse{al@\@citeb\@extra@b@citeb}}}
\let\NAT@up\relax
\newcommand\NAT@Up[1]{{\let\protect\@unexpandable@protect\let~\relax
  \expandafter\NAT@deftemp#1}\expandafter\NAT@UP\NAT@temp}
\newcommand\NAT@deftemp[1]{\xdef\NAT@temp{#1}}
\newcommand\NAT@UP[1]{\let\@tempa\NAT@UP\ifcat a#1\MakeUppercase{#1}%
  \let\@tempa\relax\else#1\fi\@tempa}
\renewcommand\@biblabel[1]{\hfill}
\newlength{\bibhang}
\setlength{\bibhang}{1em}
\newlength{\bibsep}
\setlength{\bibsep}{\z@}

\newcommand\@bibsetup%
   [1]{\setlength{\leftmargin}{\bibhang}\setlength{\itemindent}{-\leftmargin}%
       \setlength{\itemsep}{\bibsep}\setlength{\parsep}{\z@}}
\AtBeginDocument{\ifx\SK@def\@undefined\else
\ifx\SK@cite\@empty\else
  \SK@def\@citex[#1][#2]#3{\SK@\SK@@ref{#3}\SK@@citex[#1][#2]{#3}}\fi
\ifx\SK@citeauthor\@undefined\def\HAR@checkdef{}\else
  \let\citeauthor\SK@citeauthor
  \let\citefullauthor\SK@citefullauthor
  \let\citeyear\SK@citeyear\fi
\fi}
\newif\ifNAT@full\NAT@fullfalse
\newif\ifNAT@swa
\DeclareRobustCommand\citet
   {\begingroup\NAT@swafalse\def\NAT@ctype{0}\NAT@partrue
     \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\newcommand\NAT@citetp{\@ifnextchar[{\NAT@@citetp}{\NAT@@citetp[]}}
\newcommand\NAT@@citetp{}
\def\NAT@@citetp[#1]{\@ifnextchar[{\@citex[#1]}{\@citex[][#1]}}
\DeclareRobustCommand\citep
   {\begingroup\NAT@swatrue\def\NAT@ctype{0}\NAT@partrue
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\cite
    {\begingroup\def\NAT@ctype{0}\NAT@partrue\NAT@swatrue
      \@ifstar{\NAT@fulltrue\NAT@cites}{\NAT@fullfalse\NAT@cites}}
\newcommand\NAT@cites{\@ifnextchar [{\NAT@@citetp}{%
     \NAT@swafalse
    \NAT@@citetp[]}}
\DeclareRobustCommand\citealt
   {\begingroup\NAT@swafalse\def\NAT@ctype{0}\NAT@parfalse
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citealp
   {\begingroup\NAT@swatrue\def\NAT@ctype{0}\NAT@parfalse
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citeauthor
   {\begingroup\NAT@swafalse\def\NAT@ctype{1}\NAT@parfalse
    \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\Citet
   {\begingroup\NAT@swafalse\def\NAT@ctype{0}\NAT@partrue
     \let\NAT@up\NAT@Up
     \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\Citep
   {\begingroup\NAT@swatrue\def\NAT@ctype{0}\NAT@partrue
     \let\NAT@up\NAT@Up
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\Citeauthor
   {\begingroup\NAT@swafalse\def\NAT@ctype{1}\NAT@parfalse
     \let\NAT@up\NAT@Up
    \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citeyear
   {\begingroup\NAT@swafalse\def\NAT@ctype{2}\NAT@parfalse\NAT@citetp}
\DeclareRobustCommand\citeyearpar
   {\begingroup\NAT@swatrue\def\NAT@ctype{2}\NAT@partrue\NAT@citetp}
\newcommand\citetext[1]{\NAT@open#1\NAT@close}
\DeclareRobustCommand\citefullauthor
   {\citeauthor*}
\newcommand\defcitealias[2]{%
   \@ifundefined{al@#1\@extra@b@citeb}{}
   {\PackageWarning{natbib}{Overwriting existing alias for citation #1}}
   \@namedef{al@#1\@extra@b@citeb}{#2}}
\DeclareRobustCommand\citetalias{\begingroup
   \NAT@swafalse\def\NAT@ctype{3}\NAT@parfalse\NAT@citetp}
\DeclareRobustCommand\citepalias{\begingroup
   \NAT@swatrue\def\NAT@ctype{3}\NAT@partrue\NAT@citetp}
\renewcommand\nocite[1]{\@bsphack
  \@for\@citeb:=#1\do{%
    \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
    \if*\@citeb\else
    \@ifundefined{b@\@citeb\@extra@b@citeb}{%
       \NAT@citeundefined \PackageWarning{natbib}%
       {Citation `\@citeb' undefined}}{}\fi}%
  \@esphack}
\newcommand\NAT@parse[1]{{%
     \let\protect=\@unexpandable@protect\let~\relax
     \let\active@prefix=\@gobble
     \xdef\NAT@temp{\csname b@#1\@extra@b@citeb\endcsname}}%
     \expandafter\NAT@split\NAT@temp
     \expandafter\NAT@parse@date\NAT@date??????@@%
}
\newcommand\NAT@split[4]{%
  \gdef\NAT@num{#1}\gdef\NAT@name{#3}\gdef\NAT@date{#2}%
  \gdef\NAT@all@names{#4}%
  \ifx\NAT@noname\NAT@all@names \gdef\NAT@all@names{#3}\fi}
\newcommand\NAT@parse@date{}
\def\NAT@parse@date#1#2#3#4#5#6@@{%
  \ifnum\the\catcode`#1=11\def\NAT@year{}\def\NAT@exlab{#1}\else
  \ifnum\the\catcode`#2=11\def\NAT@year{#1}\def\NAT@exlab{#2}\else
  \ifnum\the\catcode`#3=11\def\NAT@year{#1#2}\def\NAT@exlab{#3}\else
  \ifnum\the\catcode`#4=11\def\NAT@year{#1#2#3}\def\NAT@exlab{#4}\else
    \def\NAT@year{#1#2#3#4}\def\NAT@exlab{{#5}}\fi\fi\fi\fi}
\newcommand\NAT@ifcmd{\futurelet\NAT@temp\NAT@ifxcmd}
\newcommand\NAT@ifxcmd{\ifx\NAT@temp\relax\else\expandafter\NAT@bare\fi}
\def\NAT@bare#1(#2)#3(@)#4\@nil#5{%
  \stepcounter{NAT@ctr}%
  \NAT@wrout{\arabic {NAT@ctr}}{#2}{#1}{#3}{#5}
}
\newcommand\NAT@wrout[5]{%
\if@filesw
      {\let\protect\noexpand\let~\relax
       \immediate
       \write\@auxout{\string\bibcite{#5}{{#1}{#2}{{#3}}{{#4}}}}}\fi
\ignorespaces}
\def\NAT@noname{{}}
\renewcommand\bibitem{%
  \@ifnextchar[{\@lbibitem}{%
    \stepcounter{NAT@ctr}\@lbibitem[\arabic{NAT@ctr}]}}
\def\@lbibitem[#1]#2{%
  \if\relax\@extra@b@citeb\relax\else
    \@ifundefined{br@#2\@extra@b@citeb}{}{%
     \@namedef{br@#2}{\@nameuse{br@#2\@extra@b@citeb}}}\fi
   \@ifundefined{b@#2\@extra@b@citeb}{\def\NAT@num{}}{\NAT@parse{#2}}%
   \item[\hfil\hyper@natanchorstart{#2\@extra@b@citeb}\@biblabel{\NAT@num}%
    \hyper@natanchorend]%
    \NAT@ifcmd#1(@)(@)\@nil{#2}}
\ifx\SK@lbibitem\@undefined\else
   \let\SK@lbibitem\@lbibitem
   \def\@lbibitem[#1]#2{%
     \SK@lbibitem[#1]{#2}\SK@\SK@@label{#2}\ignorespaces}\fi
\providecommand\bibcite{}
\renewcommand\bibcite[2]{\@ifundefined{b@#1\@extra@binfo}\relax
     {\NAT@citemultiple
      \PackageWarningNoLine{natbib}{Citation `#1' multiply defined}}%
  \global\@namedef{b@#1\@extra@binfo}{#2}}
\AtEndDocument{\NAT@swatrue\let\bibcite\NAT@testdef}
\newcommand\NAT@testdef[2]{%
  \def\NAT@temp{#2}\expandafter \ifx \csname b@#1\@extra@binfo\endcsname
    \NAT@temp \else \ifNAT@swa \NAT@swafalse
       \PackageWarningNoLine{natbib}{Citation(s) may have
          changed.\MessageBreak
          Rerun to get citations correct}\fi\fi}
\def\bibsection{%\if@draft\newpage\fi
    \noappendix\section*{\refname}}
\newcounter{NAT@ctr}
\renewenvironment{thebibliography}[1]{%
 \bibsection\parindent \z@\bibpreamble\bibfont\list
   {\@biblabel{\arabic{NAT@ctr}}}{\@bibsetup{#1}%
    \setcounter{NAT@ctr}{0}}%
      \def\newblock{\hskip .11em plus.33em minus.07em}%
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax
 }{\def\@noitemerr{%
  \PackageWarning{natbib}
     {Empty `thebibliography' environment}}%
  \endlist\vskip-\lastskip}
\let\bibfont\small
\let\bibpreamble\relax
\providecommand\reset@font{\relax}
\providecommand\bibname{Bibliography}
\providecommand\refname{References}
\newcommand\NAT@citeundefined{\gdef \NAT@undefined {%
    \PackageWarningNoLine{natbib}{There were undefined citations}}}
\let \NAT@undefined \relax
\newcommand\NAT@citemultiple{\gdef \NAT@multiple {%
    \PackageWarningNoLine{natbib}{There were multiply defined citations}}}
\let \NAT@multiple \relax
\AtEndDocument{\NAT@undefined\NAT@multiple}
\providecommand\@mkboth[2]{}
\providecommand\MakeUppercase{\uppercase}
\providecommand{\@extra@b@citeb}{}
\gdef\@extra@binfo{}
\providecommand\hyper@natanchorstart[1]{}
\providecommand\hyper@natanchorend{}
\providecommand\hyper@natlinkstart[1]{}
\providecommand\hyper@natlinkend{}
\providecommand\hyper@natlinkbreak[2]{#1}
\AtBeginDocument{\@ifundefined{bbl@redefine}{}{%
\let\@citex\org@@citex
\bbl@redefine\@citex[#1][#2]#3{%
  \@safe@activestrue\org@@citex[#1][#2]{#3}\@safe@activesfalse}%
\bbl@redefine\NAT@testdef#1#2{%
  \@safe@activestrue\org@NAT@testdef{#1}{#2}\@safe@activesfalse}%
\@ifundefined{org@@lbibitem}{%
\bbl@redefine\@lbibitem[#1]#2{%
  \@safe@activestrue\org@@lbibitem[#1]{#2}\@safe@activesfalse}}{}%
}}
\ifnum\NAT@sort>0
\newcommand\NAT@sort@cites[1]{%
\@tempcntb\m@ne
\let\@celt\delimiter
\def\NAT@num@list{}%
\def\NAT@cite@list{}%
\def\NAT@nonsort@list{}%
\@for \@citeb:=#1\do{\NAT@make@cite@list}%
\edef\NAT@cite@list{\NAT@cite@list\NAT@nonsort@list}%
\edef\NAT@cite@list{\expandafter\NAT@xcom\NAT@cite@list @@}}
\begingroup \catcode`\_=8
\gdef\NAT@make@cite@list{%
     \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \@ifundefined{b@\@citeb\@extra@b@citeb}{\def\NAT@num{A}}%
    {\NAT@parse{\@citeb}}%
      \ifcat _\ifnum\z@<0\NAT@num _\else A\fi
       \@tempcnta\NAT@num \relax
       \ifnum \@tempcnta>\@tempcntb
          \edef\NAT@num@list{\NAT@num@list \@celt{\NAT@num}}%
          \edef\NAT@cite@list{\NAT@cite@list\@citeb,}%
          \@tempcntb\@tempcnta
       \else
          \let\NAT@@cite@list=\NAT@cite@list \def\NAT@cite@list{}%
          \edef\NAT@num@list{\expandafter\NAT@num@celt \NAT@num@list \@gobble @}%
          {\let\@celt=\NAT@celt\NAT@num@list}%
       \fi
    \else
       \edef\NAT@nonsort@list{\NAT@nonsort@list\@citeb,}%
 \fi}
\endgroup
\def\NAT@celt#1{\ifnum #1<\@tempcnta
  \xdef\NAT@cite@list{\NAT@cite@list\expandafter\NAT@nextc\NAT@@cite@list @@}%
  \xdef\NAT@@cite@list{\expandafter\NAT@restc\NAT@@cite@list}%
 \else
  \xdef\NAT@cite@list{\NAT@cite@list\@citeb,\NAT@@cite@list}\let\@celt\@gobble%
 \fi}
\def\NAT@num@celt#1#2{\ifx \@celt #1%
     \ifnum #2<\@tempcnta
        \@celt{#2}%
        \expandafter\expandafter\expandafter\NAT@num@celt
     \else
        \@celt{\number\@tempcnta}\@celt{#2}%
  \fi\fi}
\def\NAT@nextc#1,#2@@{#1,}
\def\NAT@restc#1,#2{#2}
\def\NAT@xcom#1,@@{#1}
\else
 \newcommand\NAT@sort@cites[1]{\edef\NAT@cite@list{#1}}\fi
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{balance}
         [1999/02/23 4.3 (PWD)]
\newcommand{\@BAlancecol}{\if@twocolumn
  \setbox0=\vbox{\unvbox\@outputbox} \@tempdima=\ht0
  \advance\@tempdima by \topskip \advance\@tempdima
     by -\baselineskip \divide\@tempdima by 2
     \splittopskip=\topskip
  {\vbadness=\@M \loop \global\setbox3=\copy0
   \global\setbox1=\vsplit3 to \@tempdima
   \ifdim\ht3>\@tempdima \global\advance\@tempdima by 1pt \repeat}
   \setbox\@leftcolumn=\vbox to \@tempdima{\unvbox1\vfil}
   \setbox\@outputbox=\vbox to \@tempdima
     {\dimen2=\dp3\unvbox3\kern-\dimen2
      \vfil}
  \fi}
\newif\if@BAlanceone
\global\@BAlanceonefalse
\newdimen\oldvsize
\newcommand{\@BAdblcol}{\if@firstcolumn
       \unvbox\@outputbox \penalty\outputpenalty
       \global\oldvsize=\@colht \global\multiply \@colht by 2
       \global\@BAlanceonetrue
       \global\@firstcolumnfalse
  \else \global\@firstcolumntrue
       \if@BAlanceone
       \global\@BAlanceonefalse\@BAlancecol
       \global\@colht=\oldvsize \else
       \PackageWarningNoLine{balance}
          {You have called \protect\balance\space
             in second column\MessageBreak
           Columns might not be balanced}\fi
     \setbox\@outputbox\vbox to \@colht{\hbox to\textwidth
     {\hbox to\columnwidth {\box\@leftcolumn \hss}\hfil
      \vrule width\columnseprule\hfil \hbox to\columnwidth
      {\box\@outputbox \hss}}\vfil}\@combinedblfloats
     \@outputpage \begingroup \@dblfloatplacement
     \@startdblcolumn \@whilesw\if@fcolmade \fi
     {\@outputpage\@startdblcolumn}\endgroup
  \fi}
\newcommand{\@BAcleardblpage}{\clearpage\if@twoside \ifodd\c@page\else
  \hbox{}\newpage\fi\fi}
\newcommand{\@@cleardblpage}{}
\let\@@cleardblpage=\cleardoublepage

\newcommand{\@@utputdblcol}{}
\let\@@utputdblcol=\@outputdblcol
\newcommand{\balance}{\global\let\@outputdblcol=\@BAdblcol
  \global\let\cleardoublepage=\@BAcleardblpage}
\newcommand{\nobalance}{\global\let\@outputdblcol=\@@utputdblcol
  \global\let\cleardoublepage=\@@cleardblpage}
\endinput
%%
%% End of file `isss.cls'.
