#ifndef __MMcEvt__
#define __MMcEvt__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "TObject.h"


class MMcEvt : public TObject {
 private:
  UShort_t usPartId;     // Type of particle
  Float_t fEnergy;       // Energy in GeV

  Float_t fTheta;        // Theta angle of event 
  Float_t fPhi;          // Phi angle of event 

  Float_t fCoreD;        // Core d pos
  Float_t fCoreX;        // Core x pos
  Float_t fCoreY;        // Core y pos
  Float_t fImpact;       // impact parameter

  UShort_t usPhotIni;      // Initial number of photons
  UShort_t usPassPhotAtm;  // Passed atmosphere
  UShort_t usPassPhotRef;  // Passed reflector
  UShort_t usPassPhotCone; // Passed glas
  UShort_t usPhotEl    ;   // Passed qe
 

 public:
  MMcEvt() ;
  
  MMcEvt( UShort_t, 
	  Float_t, Float_t, Float_t, Float_t, Float_t, Float_t, Float_t,
	  UShort_t, UShort_t, UShort_t, UShort_t, UShort_t ) ; 
  
  ~MMcEvt(); 

  void Clear();

  void Fill( UShort_t, 
	     Float_t, Float_t, Float_t, Float_t, Float_t, Float_t, Float_t,
	     UShort_t, UShort_t, UShort_t, UShort_t, UShort_t ) ; 


  void Print(Option_t *);



/*    Short_t GetPartId() { return usPartId; }       //Get Type of particle */
/*    Float_t GetEnergy() { return fEnergy; }        //Get Energy */

/*    Float_t GetTheta() { return fTheta; }          //Get Theta angle */
/*    Float_t GetPhi() { return fPhi ;  }            //Get Phi angle */

/*    Float_t GetCoreD() { return fCoreD; }          //Get Core d pos */
/*    Float_t GetCoreX() { return fCoreX; }          //Get Core x pos */
/*    Float_t GetCoreY() { return fCoreY; }          //Get Core y pos */
/*    Float_t GetImpact() { return fImpact;}         //Get impact parameter */

/*    Short_t GetPhotIni() { return usPhotIni; }           //Get Initial photons */
/*    Short_t GetPassPhotAtm() { return usPassPhotAtm;}    //Get Passed atmosphere */
/*    Short_t GetPassPhotRef() { return usPassPhotRef; }   //Get Passed reflector */
/*    Short_t GetPassPhotCone() { return usPassPhotCone; } //Get Passed glas */
/*    Short_t GetPhotEl() { return usPhotEl; }             //Get Passed qe */



 /*  void SetPartId(Short_t PartId)  */
/*     { usPartId=PartId; }             //Set Type of particle */
/*   void SetEnergy(Float_t Energy)  */
/*     { fEnergy=Energy; }              //Set Energy */
 
/*   void SetTheta(Float_t Theta)  */
/*     { fTheta=Theta; }                //Set Theta angle */
/*   void SetPhi(Float_t Phi)  */
/*     { fPhi=Phi;  }                   //Set Phi angle */
 
/*    void SetCoreD(Float_t CoreD)  */
/*      { fCoreD=CoreD; }                //Set Core d pos */
/*    void SetCoreX(Float_t CoreX)  */
/*      { fCoreX=CoreX; }                //Set Core x pos */
/*    void SetCoreY(Float_t CoreY )  */
/*      { fCoreY=CoreY; }                //Set Core y pos */
/*    void SetImpact(Float_t Impact)  */
/*      { fImpact=Impact;}               //Set impact parameter */
  
/*    void SetPhotIni(Short_t PhotIni)  */
/*      { usPhotIni=PhotIni; }                 //Set Initial photons */
/*    void SetPassPhotAtm(Short_t PassPhotAtm)  */
/*      { usPassPhotAtm=PassPhotAtm;}         //Set Passed atmosphere */
/*    void SetPassPhotRef(Short_t PassPhotRef)  */
/*      { usPassPhotRef=PassPhotRef ; }       //Set Passed reflector */
/*    void SetPassPhotCone(Short_t PhotCon)  */
/*      { usPassPhotCone=PhotCon; }           //Set Passed glas */
/*    void SetPhotEl(Short_t PhotEl)  */
/*      { usPhotEl=PhotEl; }                  //Set Passed qe */


  ClassDef(MMcEvt, 1)  //Stores Montecarlo Information 

};

#endif
