#ifndef __MRawEvt__
#define __MRawEvt__

#include <iostream.h>
#include "TObject.h"
#include "TClonesArray.h"

#include "Mdefine.h" 

class MRawEvt : public TObject { 

 private: 
  UInt_t        uiEvtNo     ;  // Number of Event

  ULong_t       ulTimeStamp ;  // Time of the Event

  UChar_t       ucEvtStatus ;  // Status of this event (DAQ, Pedestal, ..) 
 
  UShort_t      usTrig1st   ;  // Number of 1st level tiggers between 2 events

  UShort_t      usMultPixel ;  // Multiplicity of the Pixels in this event   

  TClonesArray  *taPixels   ;  // list of the events

 public: 

  MRawEvt() ; 

  ~MRawEvt(); 

  void Clear() ; 
  
  void Print() ; 

  void FillRandom( UInt_t, ULong_t, UShort_t   ) ; 

  void FillHeader( UInt_t, ULong_t ) ; 

  void FillPixel(  UShort_t, Float_t * ) ; 
 
  void FillMontCarl ( UInt_t, ULong_t, Float_t * ) ;

  UShort_t GetMultPixel(); 

  TClonesArray *&GetPixelList() {
  //
  //   returns a Pointer to the pixel list
  //
  return  taPixels ;
}


/*    void AddPixel( UShort_t  ) ;  */

/*    void AddPixel ( UShort_t, UChar_t, UChar_t * ) ;  */


  ClassDef ( MRawEvt, 1 )  

};  // end of class definition of MRawEvt

#endif





  




  




