#ifndef MRAWFILEREAD_H
#define MRAWFILEREAD_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class ifstream;

class MTime;
class MParList;
class MRawRunHeader;
class MRawEvtHeader;
class MRawEvtData;
class MRawCrateArray;

class MRawFileRead : public MTask
{
private:
    MParList *pParList;

    MRawRunHeader  *fRawRunHeader;
    MRawEvtHeader  *fRawEvtHeader;
    MRawEvtData    *fRawEvtData;
    MRawCrateArray *fRawCrateArray;
    MTime          *fRawEvtTime;

    ifstream *fIn; //!

public:
    MRawFileRead(const char *filename, const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MRawFileRead, 1)	// Task to read the raw data binary file
};

#endif
