#include "MGDisplayAdc.h" 

MGDisplayAdc::MGDisplayAdc ( MHistosAdc *Histos,
			     const TGWindow *p, const TGWindow *main, 
			     UInt_t w, UInt_t h, 
			     UInt_t options) 
  : TGTransientFrame(p, main, w, h, options ) 
{
  //   default constructor

  fHists = Histos ; 

  //   the top frame for the list and some buttons and the Canvas 

  fFrameTop = new TGHorizontalFrame (this, 60,20,  kFitWidth ) ;

  //    left part of top frame
  fFT1 =  new TGVerticalFrame (fFrameTop, 80,300,  kFitWidth ) ; 

  fHistoList = new TGListBox ( fFT1, M_LIST_HISTO ) ; 
  fHistoList->Associate( this ) ; 
  fFT1->AddFrame ( fHistoList, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 10, 10 ) )  ; 
  fHistoList->Resize(80, 300 ) ; 

  fFrameTop->AddFrame (fFT1, new TGLayoutHints ( kLHintsTop , 10, 10, 10, 10 ) ) ; 


  //    middle part of top frame
 
  fFT2 =  new TGVerticalFrame (fFrameTop, 80,20,  kFitWidth ) ;  

  fButtonPrev = new TGTextButton ( fFT2, "Prev Histo", M_BUTTON_PREV ) ; 
  fButtonPrev->Associate (this) ; 
  fFT2->AddFrame ( fButtonPrev, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 50, 10 ) )  ; 

  fButtonNext = new TGTextButton ( fFT2, "Next Histo", M_BUTTON_NEXT ) ; 
  fButtonNext->Associate (this) ; 
  fFT2->AddFrame ( fButtonNext, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 10, 5 ) )  ; 

  fFrameTop->AddFrame (fFT2, new TGLayoutHints ( kLHintsTop , 10, 10, 10, 10 ) ) ; 

  //    right part of top frame
  
  fFT3 =  new TGVerticalFrame (fFrameTop, 60, 60,  kFitWidth ) ;

  fECanv = new TRootEmbeddedCanvas("fECanv", fFT3, 400, 400 ) ; 
  fFT3->AddFrame( fECanv, new TGLayoutHints ( kLHintsCenterX | kLHintsCenterY | kLHintsExpandX | kLHintsExpandY , 10, 10, 10, 10 ) ) ; 

  fCanv = fECanv->GetCanvas() ; 

  fFrameTop->AddFrame (fFT3, new TGLayoutHints ( kLHintsCenterX | kLHintsCenterY | kLHintsExpandX | kLHintsExpandY , 10, 10, 10, 10 ) ) ; 
  
  AddFrame ( fFrameTop, new TGLayoutHints ( kLHintsTop | kLHintsExpandX , 10, 10, 10, 10 ) ) ; 

  //
  //   the low frame for the control buttons
  //
  fFrameLow = new TGHorizontalFrame (this, 60,20, kFixedWidth ) ;
    
  fButtonSave = new TGTextButton ( fFrameLow, "Save", M_BUTTON_SAVE ) ; 
  fButtonSave->Associate (this) ; 
  fFrameLow->AddFrame ( fButtonSave, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 5, 5 ) )  ; 

  fButtonPrint = new TGTextButton ( fFrameLow, "Print", M_BUTTON_PRINT ) ; 
  fButtonPrint->Associate (this) ; 
  fFrameLow->AddFrame ( fButtonPrint, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 5, 5 ) )  ; 

  fButtonPrintAll = new TGTextButton ( fFrameLow, "PrintAll", M_BUTTON_PRINTALL ) ; 
  fButtonPrintAll->Associate (this) ; 
  fFrameLow->AddFrame ( fButtonPrintAll, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 5, 5 ) )  ; 

  fButtonClose = new TGTextButton ( fFrameLow, "Close", M_BUTTON_CLOSE ) ; 
  fButtonClose->Associate (this) ; 
  fFrameLow->AddFrame ( fButtonClose, new TGLayoutHints (kLHintsLeft | kLHintsTop, 10, 10, 5, 5 ) )  ; 
  AddFrame ( fFrameLow, new TGLayoutHints ( kLHintsBottom | kLHintsExpandX , 10, 10, 10, 10 ) ) ; 

  //
  //
  //
  BuildHistoList() ; 

  MapSubwindows();
  
  Layout();
  
  SetWindowName("ADC Spectra");
  SetIconName("ADC Spectra");
  
  MapWindow(); 
}  
  
// ======================================================================
// ======================================================================



MGDisplayAdc::~MGDisplayAdc () 
{ 
  delete fButtonSave ; 
  delete fButtonPrint ; 
  delete fButtonPrintAll ; 
  delete fButtonClose ; 
 
  delete fButtonPrev; 
  delete fButtonNext ; 
  
  delete fECanv ; 
  delete fHistoList ; 
  delete fFT1 ; 
  delete fFT2 ; 
  delete fFT3 ; 
  delete fFrameLow ; 
  delete fFrameTop ; 
  
}  

// ======================================================================
// ======================================================================

void MGDisplayAdc::CloseWindow()
{
   // Got close message for this MainFrame. Calls parent CloseWindow()
   // (which destroys the window) and terminate the application.
   // The close message is generated by the window manager when its close
   // window menu item is selected.

  delete this ; 
  //  TGTransientFrame::CloseWindow();
  //  TGMainFrame::CloseWindow();
  //   gROOT->GetApplication()->Terminate(0)  ; 
}


// ======================================================================
// ======================================================================

Bool_t MGDisplayAdc::BuildHistoList() 
{ 
  //   looks in the container of the AdcSpectra and reads in the 
  //   Histogramms in there. 
  //
  //   In the class MHistosAdc are in fact two lists. One for the high and
  //   one for the low gain. Here we will use only the high gain list!!!
  //   With some special options (settings in the gui) we will also be able
  //   to plot the low gain
  
  for ( Int_t i=0 ; i < fHists->GetHighEntries(); i++ ) { 
 
    fHistoList->AddEntry(fHists->GetHighList()->At(i)->GetName(), i+1) ; 
  } 
  
  fHistoList->MapSubwindows() ; 
  fHistoList->Layout() ; 

  return (kTRUE) ; 
} 

// ======================================================================
// ======================================================================

Bool_t MGDisplayAdc::ProcessMessage(Long_t msg, Long_t parm1, Long_t)
{     
  // Process events generated by the buttons in the frame.
  
  Int_t   buttons = 4, retval = 0 ; 
  Char_t  wort[100] ;
  Char_t  extens[5] ;
  Char_t  command[110] ;
 
  TGFileItem *item ;     // to process items in the file view container
  void *np = NULL ;      // null pointer

  switch (GET_MSG(msg)) 
    {
    case kC_COMMAND:
      switch (GET_SUBMSG(msg)) 
	{
	case kCM_BUTTON:
	  
	  switch (parm1)
	    {  

	    case M_BUTTON_SAVE: 
	      break ; 
	      
	    case M_BUTTON_CLOSE: 
	      CloseWindow() ; 
	      break ; 
	      
	    default:
	      break ;
	    } 

	case kCM_MENU:
	  switch (parm1) {
	  }
	  break ;
	  
	default:
	  break ;
	  
	}

    case kCM_LISTBOX:
      switch  (GET_SUBMSG(msg)) 
	{
	case M_LIST_HISTO: 
	  fCanv->cd() ; 
	  
	  fHists->GetHighList()->At( fHistoList->GetSelected()-1)->Draw() ; 

	  fCanv->Modified() ; 
	  fCanv->Update() ; 
	  
	  break; 
	  
	default:
	  break ;
	}

    case kC_CONTAINER: 
      switch (GET_SUBMSG(msg)) {
	      
      case kCT_ITEMDBLCLICK: 
	
	break; 
	
      default:
	break ;
      }
      
      
      
    default:
      break;
    }
  return kTRUE;
} 
