#ifndef MARRAY_H
#define MARRAY_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class MArray : public TObject
{
protected:
    Int_t fN; // Number of array elements

public:
   MArray()                              { fN = 0; }
   MArray(Int_t n)                       { fN = n; }
   MArray(const MArray &a)               { fN = a.fN; }
   virtual ~MArray()                     { fN = 0; }

   MArray &operator=(const MArray &rhs)  { fN = rhs.fN; return *this; }

   Int_t        GetSize() const          { return fN; }
   virtual void Set(Int_t n) = 0;

   ClassDef(MArray, 1)  //Abstract array base class for TObject derived Arrays
};

#endif
