//
//
//
//
//
//
#include <stdlib.h>
#include "TROOT.h"

#include "TFile.h"
#include "TNtuple.h"

#include "COREventHeader.hxx"
#include "CORParticle.hxx"
#include "CORStatfile.hxx"

#include "MSimone.hxx"

main() 
  {
    // initialise ROOT

    TROOT simple("simple", "SIMONE - statistic of MonteCarlo");
              
    //    char  path[100] = "/hd61/Maggi/Data/mcMAGIC-1-30:30000-1" ; 
    char  path[100] = "/hd31/Data/mmcs_prod_1009_30:30000_14" ; 
    //    char  path[100] = "/data/mmcs/" ; 
    char  cername[120] ; 
    char  datname[120] ; 

    ifstream   cerfile ; 

    COREventHeader Event ;   
    
    MSimone    Infos ; 
    Infos.Print() ; 
    //
    //    now create a root-file for the ntuple output
    // 

    TFile *outfile = new TFile("simone.root","RECREATE");

    TNtuple *Ntup = new TNtuple("simone",
			       "Simone info of mmcs",
			       "PartId:Energy:Theta:Phi");


    for (int i_cer = 1; i_cer < 1000; i_cer++ ) {

      //
      //   create the file names 
      //
      sprintf ( cername, "%s/cer%06d", path, i_cer ) ; 
      sprintf ( datname, "%s/dat%06d", path, i_cer ) ; 

      //      cout << cername  << endl ; 
      //      cout << datname  << endl ; 

      //
      //   try to open the files
      // 

      cerfile.open( cername );
        
      if ( cerfile.bad() ) { 
        cout << "Cannot open input file:  " << cername << endl ;
	continue ; 
      }
          
      cout << " Read event " << endl ;
      Event.read( cerfile );
      
      Infos.Transfer ( &Event ) ; 

      Infos.Print() ; 

      Infos.NtupFill ( Ntup ) ; 
 
      cerfile.close();

    } 
    

    //
    //   write all to file
    //
    outfile->Write() ; 

  } 


