#ifndef MGDISPLAYADC_H
#define MGDISPLAYADC_H

#include <iostream.h>
#include <TROOT.h> 
#include <TApplication.h> 
#include <TSystem.h> 
#include <TGClient.h> 
#include <TGButton.h>
#include <TGMenu.h>
#include <TGTab.h> 
#include <TGListBox.h> 
#include <TGPicture.h>
#include <TRootEmbeddedCanvas.h>
#include <TCanvas.h>
#include <TGFSContainer.h>
#include <TGMsgBox.h>
#include <TVirtualX.h>
#include <TGFrame.h>
#include <TGTextEntry.h>
#include <TGSlider.h>
#include <TGDoubleSlider.h>
#include <TGScrollBar.h>
#include <TSlider.h>


#include <TVirtualX.h>
#include <TGClient.h>   
    
#include "MHistosAdc.h"
	
    class MHistosAdc;



enum ComIdentDisplayAdc {
	M_BUTTON_SAVE,
		M_BUTTON_PRINT,
		M_BUTTON_PRINTALL,
		M_BUTTON_CLOSE , 
		
		M_BUTTON_PREV, 
		M_BUTTON_NEXT,

		M_LIST_HISTO,
		M_RADIO_HIGH,
		M_RADIO_LOW,
		M_RADIO_LH,
		M_BUTTON_RESET,
		M_VSId1
} ; 

class MGDisplayAdc : public TGTransientFrame {
    private:
	
	MHistosAdc *fHists;		// Pointer to Container with the histograms
	
	// Create a main frame with a number of different buttons.
	//   
	TGCompositeFrame  *fFrameTop ;   // top part of the main window
	TGCompositeFrame  *fFrameLow ;   // low part of the main window
  
	TGVerticalFrame   *fFT1, *fFT2, *fFT3 ;
	
	TGListBox         *fHistoList ;
	TGTextButton      *fButtonPrev, *fButtonNext , *fButtonReset ;
	
	TRootEmbeddedCanvas  *fECanv , *fECanvLow;

	TGTextButton   *fButtonSave, *fButtonPrint, *fButtonPrintAll, *fButtonClose ; 
	
	TCanvas            *fCanv ;	
	
	
	//for sliders
	
	TGVSlider       *fVslider1;
	
       
	
  
    public:
	
	//for radio buttons

	TGRadioButton *fRadio[3];

	
        Int_t    fHistoType;
        Bool_t    fHistoLock; 
	//
			
	
	TGPicture *fPicture;  
	TCanvas *fCanvas;
	
	MGDisplayAdc(MHistosAdc *fHists , 
		     const TGWindow *p, const TGWindow *main, 
		     UInt_t w, UInt_t h, 
		     UInt_t options = kMainFrame | kVerticalFrame ) ;
	
	~MGDisplayAdc(); 
  
	void  CloseWindow()  ;
       
	
	Bool_t BuildHistoList(Int_t type=1) ;
	
	Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
  
} ; 

#endif


