#ifndef MGMARSMAIN_H
#define MGMARSMAIN_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class TGTab;
class TGMenuBar;
class TGPopupMenu;
class TGTextButton;
class TGPictureButton;
class TGHorizontal3DLine;

enum CommandIdentifiers {
  M_FILE_EXIT  ,
  M_FILE_ABOUT  ,

  M_PICTURE_MAGIC , 
  M_PICTURE_MARS ,

  M_BUTTON_EVTDISP ,
  M_BUTTON_DATACHECK ,
  M_BUTTON_ANALYSE ,
  M_BUTTON_MONTECARLO 
} ; 


class MGMarsMain : public TGMainFrame {
 private:
  
  //
  // Create a main frame with a number of different buttons.
  //

  //  the things for the menu bar 
    
  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;
  TGLayoutHints     *fLayMenuBar, *fLayMenuItem ; 
  TGHorizontal3DLine *fLineSep ; 

  //   divide the Window in two different parts
  
  TGHorizontalFrame  *fTop ;   // top part of the main window
  TGHorizontal3DLine *fLineSep2 ;
  TGHorizontalFrame  *fLow ;   // low part of the main window
  TGTab              *fTab ;   // different tabs in the low window
  
  //   the object in the top part of the frame
  
  TGPictureButton *fPicMagic, *fPicMars ;
 
  //   the object in the low part of the frame
 
  TGVerticalFrame  *fTabF1, *fTabF2 ; 
  
  TGTextButton     *fButEvtDisp, *fButDataCheck, *fButAnalys, *fButMonteCarlo ;
  TGLayoutHints    *fButLayout ; 
 
 public: 
  MGMarsMain(const TGWindow *p, UInt_t w, UInt_t h) ;
  
  ~MGMarsMain(); 
  
  void CloseWindow()  ; 

  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

  ClassDef(MGMarsMain, 1)
} ; 

#endif


