#include <iostream.h>
#include "MSimone.hxx"
//==========
// MSimone
//    
// This class handles and contains the MonteCarlo information
// with which the events have been generated
// This information exists for each event.

//ClassImp(MSimone)



MSimone::MSimone() {
  //
  //  default constructor
  //  set all values to zero

  PartId = 0  ;
  Energy  = 0. ;

  Theta   = 0. ;
  Phi     = 0. ;

  CoreD   = 0. ;
  CoreX   = 0. ;
  CoreY   = 0. ;
  
  FirstInt = 0. ; 
}

MSimone::~MSimone() {
  //
  //  default destructor
  //
}




void MSimone::Clear() {
  //
  //  
  //  reset all values to zero

  PartId  = 0.  ;
  Energy  = 0.  ;

  Theta   = 0.  ;
  Phi     = 0.  ;

  CoreD   = 0.  ;
  CoreX   = 0.  ;
  CoreY   = 0.  ;
  
  FirstInt= 0.  ; 
}


void MSimone::Print(void) {
  //
  //  print out the data member on screen
  //
  cout <<endl << "Monte Carlo output:" <<endl;
  cout << " Particle Id    : " << PartId ; 
  cout << " Energy (GeV)   : " << Energy  ; 
  cout << endl ; 
}


void MSimone::Transfer( COREventHeader *e )
{
  PartId       = e->PrimaryID;
  Energy       = e->Etotal;

  Theta          = e->Theta;
  Phi            = e->Phi;
  
  FirstInt      = e->zFirstInt;
}


void MSimone::NtupFill( TNtuple *n )
{
  n->Fill(PartId,Energy,Theta,Phi) ; 
}







