#ifndef MGDISPLAYADC_H
#define MGDISPLAYADC_H

#include <iostream.h>
#include <TROOT.h> 
#include <TApplication.h> 
#include <TSystem.h> 
#include <TGClient.h> 
#include <TGButton.h>
#include <TGMenu.h>
#include <TGTab.h> 
#include <TGListBox.h> 
#include <TGPicture.h>
#include <TRootEmbeddedCanvas.h>
#include <TCanvas.h>
#include <TGFSContainer.h>
#include <TGMsgBox.h>

#include <TVirtualX.h>
#include <TGClient.h>   

#include "MHistosAdc.h"

class MHistosAdc;

enum ComIdentDisplayAdc {
  M_BUTTON_SAVE,
  M_BUTTON_PRINT,
  M_BUTTON_PRINTALL,
  M_BUTTON_CLOSE , 

  M_BUTTON_PREV, 
  M_BUTTON_NEXT,

  M_LIST_HISTO 
  
} ; 

class MGDisplayAdc : public TGTransientFrame {
 private:
  
  MHistosAdc *fHists;		// Pointer to Container with the histograms
  
  // Create a main frame with a number of different buttons.
    
  TGCompositeFrame  *fFrameTop ;   // top part of the main window
  TGCompositeFrame  *fFrameLow ;   // low part of the main window
  
  TGVerticalFrame   *fFT1, *fFT2, *fFT3 ;

  TGListBox         *fHistoList ; 
  TGTextButton      *fButtonPrev, *fButtonNext ; 
  
  TRootEmbeddedCanvas  *fECanv ; 

  TGTextButton   *fButtonSave, *fButtonPrint, *fButtonPrintAll, *fButtonClose ; 
  
  TCanvas            *fCanv ; 

 public:
  
  MGDisplayAdc(MHistosAdc *fHists , 
	       const TGWindow *p, const TGWindow *main, 
  	       UInt_t w, UInt_t h, 
	       UInt_t options = kMainFrame | kVerticalFrame ) ;

  ~MGDisplayAdc(); 
  
  void  CloseWindow()  ; 
  
  Bool_t BuildHistoList() ; 

  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
  
} ; 

#endif


