/***************************************************************************
 *   Copyright (C) 2004 by Martin Merck                                    *
 *   merck@astro.uni-wuerzburg.de                                          *
 *   
 *   This software is part of the MAGIC software.                                                                      *
 ***************************************************************************/

#ifndef _TAPERVIEW_H_
#define _TAPERVIEW_H_

#include <qwidget.h>
#include <kparts/part.h>
#include <taperiface.h>

class QPainter;
class KURL;

/**
 * This is the main view class for Taper.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This taper uses an HTML component as an example.
 *
 * @short Main view
 * @author Martin Merck <merck@astro.uni-wuerzburg.de>
 * @version 0.1
 */
class TaperView : public QWidget, public TaperIface
{
    Q_OBJECT
public:
	/**
	 * Default constructor
	 */
    TaperView(QWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~TaperView();

    /**
     * Random 'get' function
     */
    QString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual void openURL(QString url);

    /**
     * Random 'set' function
     */
    virtual void openURL(const KURL& url);

    /**
     * Print this view to any medium -- paper or not
     */
    void print(QPainter *, int height, int width);

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);

private slots:
    void slotOnURL(const QString& url);
    void slotSetTitle(const QString& title);

private:
    KParts::ReadOnlyPart *m_html;
};

#endif // _TAPERVIEW_H_
