# coding: utf-8
from pylab import *
import pandas as pd
import matplotlib.dates as mdates
from matplotlib.colors import LogNorm

r = pd.DataFrame.from_csv('burst_ratio.csv', 
	infer_datetime_format=True, 
	parse_dates=['fRunStart', 'fRunStop'])
r = r.dropna()

t = r.fRunStart.values.astype('float64')/1e9
x = r.fBoardTriggerRateRatioAboveThreshold
tt = mdates.epoch2num(t)

plt.ion()
fig, axes = plt.subplots(3,1, sharex=True)
fig.subplots_adjust(hspace=0.)
for ax in axes:
	ax.xaxis.set_major_locator(mdates.MonthLocator())
	ax.xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m-%d'))
	ax.xaxis.set_minor_locator( mdates.DayLocator())

plot0 = axes[0].hist2d(tt, x.values, 
	cmap='Greys', 
	bins=(np.arange(int(tt[0])-2, int(tt[-1])+2), 
		np.arange(0, 0.6+1/60., 1./60.)), 
	norm=LogNorm())
#plt.colorbar(plot0[-1])
axes[0].set_ylabel("Ratio")

plot1 = axes[1].hist2d(tt, r.fZenithDistanceMean.values,
	cmap='Greys', 
	bins=(np.arange(int(tt[0])-2, int(tt[-1])+2), 
		np.arange(0, 95, 1.)), 
	norm=LogNorm())
#plt.colorbar(plot1[-1])
axes[1].set_ylabel("Zenith [deg]")
plot2 = axes[2].hist2d(tt, r.fAzimuthMean.values, 
	cmap='Greys', 
	bins=(np.arange(int(tt[0])-2, int(tt[-1])+2), 
		np.arange(-270, 90 , 4)), 
	norm=LogNorm())
#plt.colorbar(plot2[-1])
axes[2].set_ylabel("Azimut [deg]")
#ax.xaxis.set_major_formatter(mdates.AutoDateFormatter(mdates.AutoDateLocator()))
#ax.xaxis.set_major_locator(mdates.AutoDateLocator())

#ax.format_xdata = mdates.DateFormatter('%Y-%m-%d %H:%M')
fig.autofmt_xdate()
plt.grid()

plt.xlabel("Time")
#plt.tight_layout()
plt.draw()

"""
H, b = np.histogram(
	r.fZenithDistanceMean.values, 
	bins = np.arange(0, 180))

H2, bx, by = np.histogram2d(
	r.fZenithDistanceMean.values, 
	x.values,
	bins=(np.arange(0, 180), np.arange(0, 0.6, 1/60.)),
	)

plt.figure()
plt.title("normiert")
plt.imshow(
	(H2.T/H).T,
	origin='upper',
	#extent=[bx[0],bx[-1],by[0],by[-1]], 
	#aspect=180,
	cmap='Greys',
	)

"""
H, b = np.histogram(
	r.fZenithDistanceMean.values, 
	bins = np.arange(0, 180))

zenit_bin_index = np.digitize(r.fZenithDistanceMean.values, np.arange(0, 180))-1
w = 1./H[zenit_bin_index]

plt.figure()
plt.hist2d(
	r.fZenithDistanceMean.values, 
	x.values, 
	weights=w,
	#cmap='Greys',
	bins = (np.arange(0, 180), np.arange(0, 0.6, 1./60.)),
	norm=LogNorm(),
	)
plt.xlabel("fZenithDistanceMean")
plt.xlim(0, 90)
plt.ylabel("fBoardTriggerRateRatioAboveThreshold")
plt.title("fZenithDistanceMean Dependence of Ratio")
plt.colorbar()
plt.grid()

H, b = np.histogram(
	r.fAzimuthMean.values, 
	bins = np.arange(-360, 360))

az_bin_index = np.digitize(r.fAzimuthMean.values, np.arange(-360, 360))-1
w = 1./H[az_bin_index]

plt.figure()
plt.hist2d(
	r.fAzimuthMean.values, 
	x.values, 
	weights=w,
	#cmap='Greys', 
	bins = (np.arange(-360, 360), np.arange(0, 0.6, 1./60.)),
	norm=LogNorm()
	)
plt.xlabel("fAzimuthMean")
plt.ylabel("fBoardTriggerRateRatioAboveThreshold")
plt.title("Azimuth Dependence of Ratio")
plt.colorbar()
plt.grid()

nbins = (
	np.arange(-2*np.pi, 2*np.pi, np.pi/180*5), 
	np.arange(0, 90)
	)

H1, bx, by = np.histogram2d(
	x=r.fAzimuthMean.values*np.pi/180.,
	y=r.fZenithDistanceMean.values,
	weights=x.values,
	bins=nbins)

H2, bx, by = np.histogram2d(
	x=r.fAzimuthMean.values*np.pi/180.,
	y=r.fZenithDistanceMean.values,
	bins=nbins)

normed_H1 = H1/H2

above_thr = normed_H1 > 0.05

runs_above_thr = H2.copy()
runs_above_thr[~above_thr]=0

plt.figure()
plt.title("Ratio vs. zenith and azimut (normalized for #runs)")
im = plt.imshow(normed_H1.T,
	origin='low',
	interpolation='none',
	extent=[bx[0], bx[-1], by[0], by[-1]],
	aspect='auto',
	norm=LogNorm())
#im.set_cmap('Greys')
cbar = plt.colorbar()
plt.grid()
plt.xlim(-1.5*np.pi, np.pi/2.)
plt.xlabel("Azimut [rad]")
plt.ylabel("Zenith [deg]")



plt.figure()
plt.title("Above 5% Ratio")
im = plt.imshow(above_thr.T,
	origin='low',
	interpolation='none',
	extent=[bx[0], bx[-1], by[0], by[-1]],
	aspect='auto',
	norm=LogNorm())
#im.set_cmap('Greys')
plt.colorbar()
plt.grid()
plt.xlim(-1.5*np.pi, np.pi/2.)

plt.figure()
plt.title("# runs above thr")
im = plt.imshow(runs_above_thr.T,
	origin='low',
	interpolation='none',
	extent=[bx[0], bx[-1], by[0], by[-1]],
	aspect='auto')
#im.set_cmap('Greys')
plt.colorbar()
plt.grid()
plt.xlim(-1.5*np.pi, np.pi/2.)

