/*

  Arduino for FACT

  Gareth Hughes 2013-10-30

  Using: Arduino Ethernet
	 GSM Overlay
	 LSM303: Magnetic field and accelerometer 
	 YL-38: Light Sensor

  Function: Will reply to an SMS stating the position, movement and light level.
	    If lighlevel gets above a certain threshold will send a warning SMS every 1 min.

*/

#include <SPI.h>
#include <Ethernet.h>

// include libraries
//GH// #include <GSM.h>
#include <Wire.h>
#include <LSM303.h>

//ETH
//byte mac[]   = { 0x90, 0xA2, 0xDA, 0x0D, 0xB5, 0xE3 };
//byte ip[]    = { 192, 33, 103, 241 };
//LA PALMA
byte mac[]   = { 0xFA, 0xC7, 0xBB, 0xFF, 0x33, 0x33 };
byte ip[]    = { 10, 0, 100, 202 };

EthernetServer server = EthernetServer(23);
EthernetClient client;
//boolean sentHeader = false;
bool sentHeader = false;

// PIN Number for the SIM
//#define PINNUMBER "0839"
#define PINNUMBER ""
//#define PINNUMBER "7143"
#define NUMLEN 15

// initialize the library instances
//GH// GSM gsmAccess;
//GH// GSM_SMS sms;
LSM303 compass;

char  message[18];      // Array to hold SMS message
//GH// char  senderNumber[NUMLEN];  // Array to hold the number a SMS is retreived from

//unsigned int   counter    =  0;     // loop counter
int   heading    = -9999;  // Continual heading reading
//int   heading2   = -9999;  // Continual heading reading
float pitch      = -9999.; // Pitch relative to horizon
int   iLight     =  9999;  // light level
int   iDiff      = -9999;  // difference in degrees
char c;

void setup() 
{


  //begin the ethernet connections
  //Ethernet.begin(mac, ip, dnserver, gatew, smask);  // this is to begin (ethz) ethernet
  Ethernet.begin(mac, ip);
  server.begin();

  // initialize serial communications and wait for port to open:
  //Serial.begin(9600);

  // Start the Wire communication
  Wire.begin();

  // Initialize the Compass
  compass.init();
  compass.enableDefault();

  // Calibration values. Use the Calibrate example program to get the values for your compass.
// ETH Calibration values
//  compass.m_min.x = -700; compass.m_min.y = -695; compass.m_min.z = -635;
//  compass.m_max.x = +293; compass.m_max.y = +551; compass.m_max.z = 606;
// La Palma calibration values
  compass.m_min.x = -389; compass.m_min.y = -423; compass.m_min.z = -420;
  compass.m_max.x = +510; compass.m_max.y = +420; compass.m_max.z = +315;
    
/* //GH//     
  // connection state
  boolean notConnected = true;
  
  // Start GSM connection
  while(notConnected)
  {
    if(gsmAccess.begin(PINNUMBER)==GSM_READY)
      notConnected = false;
    else
    {
      delay(1000);
    }
  }
*/

  // use pin 9 to mean parked!
  //pinMode(9, OUTPUT); 
 
}

void loop() 
{

/* //GH//
  // If there are any SMSs available()  
  if (sms.available())
  {

    // Get remote number
    sms.remoteNumber(senderNumber, NUMLEN);

    //if( sms.peek()=='#' )
    //{
       //sms.flush();
    //} else if( sms.peek()=='P' || sms.peek()=='p' ) 
    //} else 
    if( sms.peek()=='P' )
    {

//Serial.println("I P");

     // Generate message
      generateMessage();
      // reply to the message
      sendSMS();

    }
 
    // flush sms memory
    sms.flush();

   }
*/

  // listen for incoming clients, and process qequest.
  checkForClient();

  // Main loop 
  delay(1000);


}

/* //GH//
// Send the message.
// iType = 0: Sends reply to an SMS with the heading, movement and light level 
// iType = 1: Sends an alert to predefined number warning that the light has gone above threshold
void sendSMS()
{

  sms.beginSMS(senderNumber);
  sms.print(message);
  sms.endSMS(); 

}
*/

void checkForClient()
{

  EthernetClient client = server.available();

  if( client ) 
  {

    // an http request ends with a blank line
    boolean currentLineIsBlank = true;

    while( client.connected() ) 
    {
      if( client.available() ) 
      {

        if(!sentHeader)
	{
          printHelp();
          sentHeader = true;
        }

        c = client.read();

        switch( c ) 
        {

          case 'q':
            sentHeader = false;
            delay(1); // give the web browser time to receive the data
            client.stop(); // close the connection:
            break;
          case 'h':
            printHelp();
            break;
         case 'd':
	    generateMessage();
       	    server.println(message);
            break;
//         case 'p':
//	    digitalWrite(9, HIGH);
//            server.println("Park");
//            break;
        }

      }
    }

  } 

}

// errr Print the Help Stuff
void printHelp()
{

  server.println();
  //server.println("FACT GSM");
  //server.println("h help");
  server.println("q quit");
  server.println();
  server.println("d direction");
//  server.println("p Park Tel");
  server.println();

}

// Get the pointing difference
void getDiff()
{

  compass.read();
  heading = compass.heading((LSM303::vector){0,-1,0}) - 90 - 24;
  if( heading < 0 ) heading = heading + 360;
  //server.println(heading);

//  delay(5000);
//  compass.read();
//  heading2 = compass.heading((LSM303::vector){0,-1,0}) - 90;
//  if( heading2 < 0 ) heading2 = heading2 + 360;
//  iDiff = heading - heading2;
//  //server.println(iDiff);
    
  pitch = atan(compass.a.x/sqrt(pow(compass.a.y,2.)+pow(compass.a.z,2.)));
  pitch *= (180.0)/3.1415;  
  pitch += 13.;
  pitch  = 90. - pitch;


}

// Generate SMS
void generateMessage()
{

  // Get pointing difference
  getDiff();
  // Read light level
  iLight = analogRead(0);
  // Setup message
  sprintf(message,"%d %d %d\n",heading,(int)pitch,iLight);

}
