#include <Wire.h>
#include <LSM303.h>
#include <GSM.h>

LSM303 compass;
GSM_SMS sms;

// PIN Number
#define PINNUMBER ""

// char array of the message
  //char txtMsg[200]= "Hello";

// char array of the telephone number to send SMS
// change the number 1-212-555-1212 to a number
// you have access to
///char destinationNumber[20]= "+4917687545809";  

// initialize the library instance
GSM gsmAccess(true);     // include a 'true' parameter for debug enabled
GSMScanner scannerNetworks;
GSMModem modemTest;

// Save data variables
String IMEI = "";

// serial monitor result messages
String errortext = "ERROR";

// Array to hold the number a SMS is retreived from
char senderNumber[20];

void setup()
{

  Serial.begin(9600);
  Wire.begin();
  compass.init();
  compass.enableDefault();
  
  // Calibration values. Use the Calibrate example program to get the values for
  // your compass.
  compass.m_min.x = -700; compass.m_min.y = -695; compass.m_min.z = -635;
  compass.m_max.x = +293; compass.m_max.y = +551; compass.m_max.z = 606;

  // initialize serial communications
  Serial.begin(9600);
  Serial.println("GSM networks scanner");
  scannerNetworks.begin();

  // connection state
  boolean notConnected = true;

  // Start GSM shield
  // If your SIM has PIN, pass it as a parameter of begin() in quotes
  while(notConnected)
  {
    if(gsmAccess.begin(PINNUMBER)==GSM_READY)
      notConnected = false;
    else
    {
      Serial.println("Not connected");
      delay(1000);
    }
  }

  // get modem parameters
  // IMEI, modem unique identifier
  Serial.print("Modem IMEI: ");
  IMEI = modemTest.getIMEI();
  IMEI.replace("\n","");
  if(IMEI != NULL)
    Serial.println(IMEI);

  // currently connected carrier
  Serial.print("Current carrier: ");
  Serial.println(scannerNetworks.getCurrentCarrier());

  // returns strength and ber
  // signal strength in 0-31 scale. 31 means power > 51dBm
  // BER is the Bit Error Rate. 0-7 scale. 99=not detectable
  Serial.print("Signal Strength: ");
  Serial.print(scannerNetworks.getSignalStrength());
  Serial.println(" [0-31]");
}

void loop()
{

  char c;

  // scan for existing networks, displays a list of networks
  Serial.println("Scanning available networks. May take some seconds.");
  Serial.println(scannerNetworks.readNetworks());

  // currently connected carrier
  Serial.print("Current carrier: ");
  Serial.println(scannerNetworks.getCurrentCarrier());

  // returns strength and ber
  // signal strength in 0-31 scale. 31 means power > 51dBm
  // BER is the Bit Error Rate. 0-7 scale. 99=not detectable
  Serial.print("Signal Strength: ");
  Serial.print(scannerNetworks.getSignalStrength());
  Serial.println(" [0-31]");

  Serial.print("Outside the LOOP ");
  Serial.println(scannerNetworks.getCurrentCarrier());

  if( scannerNetworks.getCurrentCarrier() == "Orange" )
  {

////  
  // If there are any SMSs available()  
  if (sms.available())
  {
   Serial.println("Message received from:");
    
    // Get remote number
    sms.remoteNumber(senderNumber, 20);
    Serial.println(senderNumber);

    // An example of message disposal    
    // Any messages starting with # should be discarded
    if(sms.peek()=='#')
    {
      Serial.println("Discarded SMS");
      sms.flush();
    }
    
    // Read message bytes and print them
    while(c=sms.read())
      Serial.print(c);
      
    Serial.println("\nEND OF MESSAGE");
    
    // Delete message from modem memory
    sms.flush();
    Serial.println("MESSAGE DELETED");

    compass.read();
    int heading = compass.heading((LSM303::vector){0,-1,0});
    Serial.print("Pointing: ");
    Serial.println(heading);
    Serial.println("SENDING!!!");
    ///sendSMS();
////SMS////
  //Serial.print("Message to mobile number: ");
  //Serial.println(senderNumber);
  //char txtMsg[200];
  //sprintf(txtMsg,"%d",heading);
  //// sms text
  //Serial.println("SENDING");
  //Serial.println();
  //Serial.println("Message:");
  //Serial.println(txtMsg);
  //// send the message
  //sms.beginSMS(senderNumber);
  //sms.print(txtMsg);
  //sms.endSMS(); 
  //Serial.println("\nCOMPLETE!\n");  
////!SMS////
    for( ;; )
      ;


   } else 
   {
    if(!gsmAccess.begin(PINNUMBER)==GSM_READY)
      Serial.println("Not Connected!");
    Serial.println("Scanning available networks. May take some seconds.");
    Serial.println(scannerNetworks.readNetworks());
    Serial.print("Waiting ... ");
    Serial.print("Current carrier: ");
    Serial.print(scannerNetworks.getCurrentCarrier());
    Serial.print(" Signal Strength: ");
    Serial.print(scannerNetworks.getSignalStrength());
    Serial.println(" [0-31]");
    delay(1000);

  }

  } else 
  {
    Serial.println("Else Loop....");
  }


}
/*
void sendSMS()
{

  Serial.print("Message to mobile number: ");
  Serial.println(destinationNumber);

  // sms text
  Serial.println("SENDING");
  Serial.println();
  Serial.println("Message:");
  Serial.println(txtMsg);

  // send the message
  sms.beginSMS(destinationNumber);
  sms.print(txtMsg);
  sms.endSMS(); 
  Serial.println("\nCOMPLETE!\n");  
}
*/
