#include "MGNumStars.h"

#include <iostream>  // cout

#include <TLine.h>
#include <TText.h>
#include <TWbox.h>
#include <TGaxis.h>
#include <TGraph.h>
#include <TCanvas.h>

#include "MTime.h"

ClassImp(MGNumStars);

using namespace std;

void MGNumStars::DrawText(const char*txt)
{
    fCanvas->SetEditable(kTRUE);
    fCanvas->cd();

    TText text;
    text.SetTextAlign(22);  // centered, centered (s.TAttText)
    text.SetTextSize(0.12);
    text.DrawText(275, 44, txt);

    fCanvas->SetEditable(kFALSE);
}

void MGNumStars::DrawCoordinateSystem()
{
    fCanvas->Range(-50, -4, 600, 50);

    TWbox box;
    box.DrawWbox(325-150-50, 38, 325+150-50, 48,  18,  2, 1);

    TLine line;
    line.DrawLine(0, 0, 600-25, 0);
    line.SetLineStyle(kDashed);
    line.SetLineColor(kRed);
    line.DrawLine(0,  6.5, 600-25, 6.5);
    line.SetLineColor(kYellow);
    line.DrawLine(0, 10.5, 600-25, 10.5);

    TGaxis *axe;
    axe = new TGaxis(0, 0, 0, 47.5, 0, 47.5, 304, "-");
    axe->SetLabelSize(0.1);
    axe->SetLabelOffset(0.02);
    axe->SetBit(kCanDelete);
    axe->Draw();
}

void MGNumStars::InitText()
{
    fTxt = new TText(600*0.97, 50*0.92, "0/0");
    fTxt->SetTextAlign(33); // right, top
    fTxt->SetTextColor(10);
    fTxt->SetTextSize(0.12);
    fTxt->Draw();

    fList->Add(fTxt);
}

void MGNumStars::InitBar(TLine* &bar)
{
    bar = new TLine(0, 0, 0, 0);
    bar->SetLineColor(kBlack);
    bar->SetLineStyle(1);
    bar->SetLineWidth(5);
    bar->Draw();

    fList->Add(bar);
}

void MGNumStars::InitGraph(TGraph* &graph, Int_t col)
{
    graph = new TGraph;
    graph->SetPoint(0, 0, 0);
    graph->SetLineColor(col);
    graph->SetMarkerColor(col);
    graph->SetMarkerStyle(kFullDotMedium);
    graph->Draw("LP");
    fList->Add(graph);
}

MGNumStars::MGNumStars(const TGWindow* p, const UInt_t w)
: MGEmbeddedCanvas("NumStars", p, w, 300)
{
    DrawCoordinateSystem();

    InitGraph(fGraph1, kBlue);
    InitGraph(fGraph2, kCyan);

    InitText();
    InitBar(fBar1);
    InitBar(fBar2);

    InitCanvas();

    Resize(245, 100);

    SetNoContextMenu();

    MTime t(-1);
    fTime = t.GetAxisTime();
}

MGNumStars::~MGNumStars()
{
}

// dist [deg]
void MGNumStars::UpdateBar(TLine &bar, UInt_t num)
{
    bar.SetY2(num);
    if (num<11)
        bar.SetLineColor(kYellow);
    else
        if (num<7)
            bar.SetLineColor(kRed);
        else
            bar.SetLineColor(kGreen);

    SetModified();
}

// dist [deg]
void MGNumStars::UpdateGraph(TGraph &graph, Double_t dtime, UInt_t num)
{
    graph.SetPoint(graph.GetN(), dtime, num);

    const Double_t ntime = dtime;
    for (int i=0; i<graph.GetN(); i++)
    {
        Double_t x, y;
        graph.GetPoint(i, x,       y);
        graph.SetPoint(i, x+ntime, y);
    }
    while (graph.GetN()>0)
    {
        Double_t x, y;
        graph.GetPoint(0, x, y);

        if (x==+ntime && y==0)
        {
            graph.RemovePoint(0);
            continue;
        }

        if (x<2*4.75*60)
            break;

        graph.RemovePoint(0);
    }

    SetModified();
}

void MGNumStars::Update(UInt_t det, UInt_t cor)
{
    char txt[100];
    sprintf(txt, "%d/%d", cor, det);
    fTxt->SetText(fTxt->GetX(), fTxt->GetY(), txt);

    UpdateBar(*fBar1, det);
    UpdateBar(*fBar2, cor);

    MTime t(-1);
    const Double_t dtime = t.GetAxisTime()-fTime; // range [-0.5h, 0h]

    UpdateGraph(*fGraph1, dtime, det);
    UpdateGraph(*fGraph2, dtime, cor);

    fTime = t.GetAxisTime();

    UpdateCanvas();
}
