/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2008
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////////
//
// rootlogon.C
// ===========
//
// This file is the startup script ("autoexec.bat") executed when root is
// started. The definition which file to start is done in ".rootrc".
// There are three files which are automatically processed by root at
// startup: A systemwide .rootrc, one in your home directory and one
// in the current directory.
// So rootlogon.C is correctly executed if your start root from your
// Mars directory.
//
// The script setupts some small environmental things and makes
// sure that the Mars shared object (libmars.so) is loaded. This shared
// object gives you access to all Mars features from within the root
// interpreter.
//
// If libmars.so is not found in the current directory we search in the
// directory given in "MARSSYS" environment variable.
//
///////////////////////////////////////////////////////////////////////////

bool load(TString &dir)
{
    bool rc = true;

    if (dir.IsNull())
        dir = "./";

    cout << "\033[33m\033[1m" << "Loading '" << dir << "libmars.so'... " << "\033[0m" << flush;

    if (gSystem->Load(dir+"libmars.so")!=0)
    {
        cout << "\033[33m\033[1m" << "error." << endl;
        cout << "\033[0m" << endl;
        rc = false;
    }
    else
    {
        MParContainer::Class()->IgnoreTObjectStreamer();
        MArray::Class()->IgnoreTObjectStreamer();
        cout << "\033[33m\033[1m" << "done." << "\033[0m" << endl;
    }

    cout << "\033[33m\033[1m" << "Loading '" << dir << "libcosy.so'... " << "\033[0m" << flush;

    if (gSystem->Load(dir+"libcosy.so")!=0)
    {
        cout << "\033[33m\033[1m" << "error." << endl;
        cout << "\033[0m" << endl;
        rc = false;
    }
    else
    {
        //MParContainer::Class()->IgnoreTObjectStreamer();
        //MArray::Class()->IgnoreTObjectStreamer();
        cout << "\033[33m\033[1m" << "done." << endl;
        cout << "\033[0m" << endl;
    }
    return rc;
}
/*
void make()
{
    unload();

    if (gSystem->Exec("make"))
    {
        cout << "Error calling make..." << endl;
        return;
    }

    load();
}
*/
void rootlogon()
{
    cout << endl;

    const Bool_t fileexist = !gSystem->AccessPathName("libcosy.so", kFileExists);

    TString dir = fileexist ? "" : gSystem->Getenv("COSYSYS");
    if (!dir.IsNull())
    {
        cout << "\033[34m\033[1m" << "Searching Mars in " << dir << " (COSYSYS)" << "\033[0m" << endl << endl;

        if (!dir.EndsWith("/"))
            dir += "/";
    }

    if (!load(dir))
        return;

    MLog::RedirectErrorHandler(MLog::kColor);

    /*
    gInterpreter->AddIncludePath(dir+"macros");
    gInterpreter->AddIncludePath(dir+"manalysis");
    gInterpreter->AddIncludePath(dir+"mastro");
    gInterpreter->AddIncludePath(dir+"mbase");
    gInterpreter->AddIncludePath(dir+"mbadpixels");
    gInterpreter->AddIncludePath(dir+"mcamera");
    gInterpreter->AddIncludePath(dir+"mcalib");
    gInterpreter->AddIncludePath(dir+"mhcalib");
    gInterpreter->AddIncludePath(dir+"mdata");
    gInterpreter->AddIncludePath(dir+"mfbase");
    gInterpreter->AddIncludePath(dir+"mfileio");
    gInterpreter->AddIncludePath(dir+"mfilter");
    gInterpreter->AddIncludePath(dir+"mgeom");
    gInterpreter->AddIncludePath(dir+"mgui");
    gInterpreter->AddIncludePath(dir+"mhbase");
    gInterpreter->AddIncludePath(dir+"mhflux");
    gInterpreter->AddIncludePath(dir+"mhft");
    gInterpreter->AddIncludePath(dir+"mhist");
    gInterpreter->AddIncludePath(dir+"mhistmc");
    gInterpreter->AddIncludePath(dir+"mhvstime");
    gInterpreter->AddIncludePath(dir+"mimage");
    gInterpreter->AddIncludePath(dir+"mjobs");
    gInterpreter->AddIncludePath(dir+"mjoptim");
    gInterpreter->AddIncludePath(dir+"mjtrain");
    gInterpreter->AddIncludePath(dir+"mmain");
    gInterpreter->AddIncludePath(dir+"mmc");
    gInterpreter->AddIncludePath(dir+"mmontecarlo");
    gInterpreter->AddIncludePath(dir+"mmuon");
    gInterpreter->AddIncludePath(dir+"mpedestal");
    gInterpreter->AddIncludePath(dir+"mpointing");
    gInterpreter->AddIncludePath(dir+"mranforest");
    gInterpreter->AddIncludePath(dir+"mraw");
    gInterpreter->AddIncludePath(dir+"mreflector");
    gInterpreter->AddIncludePath(dir+"mreport");
    gInterpreter->AddIncludePath(dir+"msignal");
    gInterpreter->AddIncludePath(dir+"msql");
    gInterpreter->AddIncludePath(dir+"mstarcam");
    gInterpreter->AddIncludePath(dir+"mtools");
    gInterpreter->AddIncludePath(dir+"mtrigger");
    */

    if (TString("linux")==gSystem->GetBuildArch())
    {
        TString options = " -O3 -pipe -Wall -Woverloaded-virtual -fno-exceptions -fPIC ";

        TString s = "cd $BuildDir ; ";
        s += "g++ -c" + options + "-Iinclude -D_REENTRANT $IncludePath $SourceFiles ; ";
        s += "g++ $ObjectFiles -shared -Wl,-soname,$LibName.so -O -o $SharedLib";
        gSystem->SetMakeSharedLib(s);
    }

    cout << "\033[32m" << "Welcome to the Cosy Root environment." << "\033[0m" << endl;
    cout << endl;
}
