#ifndef COSY_MStarguider
#define COSY_MStarguider

#include "PixClient.h"
#include "MGImage.h"

#include "MPointing.h"

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef MARS_MGList
#include "MGList.h"
#endif

class TArrayF;
class TGLabel;
class TGButton;
class TString;
//class TSocket;

class TTimer;

class TGMenuBar;
class TGPopupMenu;
class TGTextEntry;

class PixGetter;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;
class MCosy;
class MCaos;
// class MStargLeds;
class MStargHistograms;
class MGNumStars;
class MGStarg;
class FilterLed;
class Ring;

class Leds;
#include <TGButton.h>
class MStarguider : public PixClient, public TGMainFrame
{
private:
    PixGetter     *fGetter;

    MGList        *fList;

    TGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    MGStarg       *fGStarg;
    MGNumStars    *fGNumStars;

    TGPopupMenu   *fDisplay;
    TGPopupMenu   *fMode;
    TGPopupMenu   *fWritePictures;
    TGPopupMenu   *fSetup;
    TGPopupMenu   *fOperations;

    TGPopupMenu   *fFileType;
    TGPopupMenu   *fWriteType;
    TGPopupMenu   *fWriteRate;
    TGPopupMenu   *fInterpol;
    TGPopupMenu   *fLimMag;
    TGPopupMenu   *fChannel;

    TGPopupMenu   *fCaosWrite;
    TGPopupMenu   *fCaosPrint;
    TGPopupMenu   *fCaosAnalyse;
    TGPopupMenu   *fCaOs;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    MGCoordinates *fPZdAz;
    MGCoordinates *fDZdAz;
    MGCoordinates *fSZdAz;

    TGTextEntry   *fPixSize;
    TGTextEntry   *fAngle;
    TGTextEntry   *fCut;

    TGLabel       *fFps;
    TGLabel       *fPosZoom;
    TGLabel       *fSkyBright;
    TGLabel       *fCZdAzText;
    TGLabel       *fPZdAzText;
    TGLabel       *fDZdAzText;
public:
    TGButton      *fTPoint;
//    TGButton      *fStargTPoint;
private:
    ZdAz          fPos;
    ZdAz          fD;
    AltAz         fAltAzOffsetFromTp;

    Int_t          fNumStarsDetected;
    Int_t          fNumStarsCorrelated;

    StarCatalog   *fSao;
    MCosy         *fCosy;
    MCaos         *fCaos;
    MCaos         *fStargCaos;
    MStargHistograms *fStargHistograms;
    
    RaDec *fRaDec;

    TTimer *fTimer;
    MTime   fTime;
    MTime   fTimeFromTp;

    ofstream *fOutTp;
    ofstream *fOutStargTp;
//    ofstream *fOutRq;

    Int_t fDx;
    Int_t fDy;

    byte fIntRate;
    int  fWrtRate;

    UInt_t fStatus;
    Double_t fLastBright;

    Double_t fRadius; // LED radius [cm]

    Int_t fTPointFromCC;

    Int_t fStarguiderW;
    Int_t fStarguiderH;
    Int_t fStarguiderX;
    Int_t fStarguiderY;

    Float_t fSkyOffsetX;  // Offset between camera center and sky position
    Float_t fSkyOffsetY;  // Offset between camera center and sky position

    Float_t fFindStarCut;
    Int_t   fFindStarBox;

    TString fTPointStarName;
    Float_t fTPointStarMag;

    void Toggle(TGPopupMenu *p, UInt_t id);
    void SwitchOff(TGPopupMenu *p, UInt_t id);
    void ToggleStargAnalysis();
//    void ToggleFindStar();
    void ToggleStarguider();
    void ToggleCaosFilter();
    void SetChannel();
    Int_t CalcTrackingError(const Leds &, MStarList &, ZdAz &, const MTime &, const double &bright, Int_t &num, const Ring &center, Int_t numleds, Int_t numrings);
    ZdAz TrackingError(TArrayF &alt, TArrayF &az, TArrayF &mag, Int_t &num) const;
    bool Interpolate(const unsigned long n, byte *img) const;
    void FindStar(const FilterLed &f, const FilterLed &f2, const Ring &center, const MTime &t, Int_t numleds, Int_t numrings);

    void InitGui(Int_t channel);

    void UpdatePosZoom();
    void DrawZoomImage(const byte *img);
    void DrawCosyImage(const byte *img);

    Bool_t HandleTimer(TTimer *t);

    void SetRotationAngle(Double_t angle);
    void SetPixSize(Double_t size);
    void SetCut(Double_t cut);

    Bool_t DoTPoint();

public:
    MStarguider(MObservatory::LocationName_t obs, Int_t channel);
    virtual ~MStarguider();

    void SetupEnv(TEnv &env);

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    Bool_t HandleDoubleClick(Event_t *event);

    void SetPointingPosition(RaDec rd);
    void SetCosy(MCosy *c) { fCosy = c; }

    XY GetCoordinates() const;

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    void Print(TString &str, Double_t deg) const;
    void Print(Option_t *o) const { }

    void StartTPoint(char *cmd=0);// { if (fTPointFromCC<0) fTPointFromCC=0; }
    void StartStarguider(bool on);

    Int_t GetStarguiderMode() const;

    ClassDef(MStarguider, 0)
};

#endif


