#ifndef COSY_MTracking
#define COSY_MTracking

#ifndef COSY_MSlewing
#include "MSlewing.h"
#endif

#ifndef COSY_SlaPlanets
#include "SlaPlanets.h"
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

class MLog;
class RaDec;
class SlaStars;
class MMoonPointing;

class MTracking : public MSlewing, public MThread
{
private:
    SlaPlanets fSlalib;

    ZdAz fTrackAcc;

    Int_t fTrackType;
    RaDec fTrackPos;

    Double_t fWobbleOffset;   // [rad]
    Double_t fWobbleAngle;    // [rad]

    MLog   *fOut;

    MMoonPointing *fMoon;

    Bool_t UpdateSlalib(SlaPlanets &sla);
    Bool_t UpdateSlalib(Double_t dt=0);
    Bool_t UpdateSlalib(SlaPlanets &sla, Double_t mjd);

    bool SetVelocity(const ZdAz &v);
    bool LimitSpeed(const ZdAz &vt) const;
    bool InitTracking();
    bool Move();
    void Track();

    Int_t Thread();

    ZdAz GetZdAzRad(const Slalib &sla);

public:
    MTracking(MCosy *cosy);
    ~MTracking();

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void TrackPlanet(ePlanets_t planet);  // ra, dec [rad]
    void TrackMoon(Double_t wobble, Double_t offset);
    void SetTrackAcc(Float_t zd, Float_t az) { fTrackAcc.Zd(zd); fTrackAcc.Az(az); }

    void SetWobble(Double_t offset, Double_t angle=0) { fWobbleOffset=TMath::DegToRad()*offset; fWobbleAngle=TMath::DegToRad()*angle; }

    void SetOut(MLog *fout) { fOut = fout; }

    ClassDef(MTracking, 0)
};

#endif
