#ifndef COSY_MDriveCom
#define COSY_MDriveCom

#ifndef COSY_MCeCoCom
#include "MCeCoCom.h"
#endif

class RaDec;
class AltAz;
class ZdAz;
class MsgQueue;
class Ring;
class Led;
class MLog;
class MTime;
class TVector2;

class MDriveCom : public MCeCoCom
{
private:
    MsgQueue *fQueue;

    bool ReadAngle(TString &str, Double_t &d);
    bool ReadPosition(TString &str, Double_t &d1, Double_t &d2);

    bool InterpreteCmd(TString cmd, TString str);
    void Print(TString &str, Double_t deg) const;

    bool CommandRADEC(TString &str);
    bool CommandGRB(TString &str);
    bool CommandZDAZ(TString &str);
    bool CommandCELEST(TString &str);
    bool CommandMOON(TString &str);
    bool CommandPREPS(TString &str);
    bool CommandARM(TString &str);
    bool CommandTPOINT(TString &str);
    bool CommandSTGMD(TString &str);

public:
    enum
    {
        kError      = 0x01,
        kMoving     = 0x02,
        kTracking   = 0x04,
        kStopping   = 0x08,
        kStopped    = 0x10,
	kStandby    = 0x20,
	kMonitoring = 0x40
    };

    MDriveCom(MsgQueue *q, const char *addr, const int tx, const int rx, MLog *out=NULL) : MCeCoCom(addr, tx, rx, out), fQueue(q) {}
    MDriveCom(const char *addr, const int tx, const int rx, MLog *out=NULL) : MCeCoCom(addr, tx, rx, out), fQueue(NULL) {}

    void SetMsgQueue(MsgQueue *q) { fQueue = q; }


    bool SendReport(UInt_t stat, RaDec rd, double ha, ZdAz so, ZdAz is, ZdAz er, Bool_t armed, Int_t stargmd);
    bool SendStargReport(UInt_t stat, ZdAz miss, ZdAz nompos, Ring center, Int_t num, Int_t n, Double_t bright, Double_t mjd, Int_t numleds, Int_t numrings);
    bool SendTPoint(bool stat, char type, Float_t mag, const char *name, const AltAz &za0, const ZdAz &za1,
                    const TVector2 &xy, Float_t dzd, Float_t daz, const MTime &t,
                    const Ring &center, const Led &star, Int_t numleds, Int_t numrings,
                    Int_t numstars=0, Int_t numcor=0, Float_t bright=0);

    bool SendStatus(const char *stat);
};

#endif
