#ifndef COSY_Network
#define COSY_Network

#ifndef COSY_CanOpen
#include "canopen.h"
#endif
#ifndef COSY_NodeDrv
#include "nodedrv.h"
#endif

class Network : public CanOpen
{
private:
    NodeDrv *fNodes[32];
    int fNodeInitialized[32];

    void HandleSDO(BYTE_t node, BYTE_t cmd, WORD_t idx, BYTE_t subidx, LWORD_t data, const timeval &tv);
    void HandlePDO1(BYTE_t node, const BYTE_t *data, const timeval_t &tv);
    void HandlePDO2(BYTE_t node, const BYTE_t *data, const timeval_t &tv);
    void HandlePDO3(BYTE_t node, const BYTE_t *data, const timeval_t &tv);
    void HandlePDO4(BYTE_t node, const BYTE_t *data, const timeval_t &tv);
    void HandleNodeguard(BYTE_t node, const timeval_t &tv);
    void HandleEmergency(BYTE_t node, const timeval_t &tv);

    void InitNodes();
    void StopNodes();

public:
    Network();

    void SetNode(NodeDrv *drv);

    NodeDrv *operator[](int i) { return fNodes[i]; }
    NodeDrv *GetNode(int i)    { return fNodes[i]; }

    void Start();
    void Stop();

    void PrintError() const;

    bool HasError() const;
    bool HasZombie() const;

    bool RebootZombies();
    void CheckConnections();

    ClassDef(Network, 0) // collection of nodes (nodedrv)
};

#endif
