#ifndef COSY_MsgQueue
#define COSY_MsgQueue

#ifndef ROOT_TMutex
#include <TMutex.h>
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

#define WM_NULL 0x0000
#define WM_QUIT 0xffff

class MsgQueue : public MThread
{
private:
    int    fNextMsg;
    char  *fNextPtr;

    TMutex fMuxMsg;

    Int_t Thread();

public:
    MsgQueue();
    virtual ~MsgQueue();

    int Break() const;

    virtual Int_t Proc(int msg, void *mp1);
    Int_t Proc(int msg) { return Proc(msg, 0); }

    void *PostMsg(int msg, void *mp1, int size);
    void *PostMsg(int msg) { return PostMsg(msg, 0, 0); }
};

#endif
