#ifndef STARCATALOG_H
#define STARCATALOG_H

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif
#ifndef ROOT_GuiTypes
#include <GuiTypes.h>
#endif
#ifndef COSY_SlaStars
#include "SlaStars.h"
#endif

typedef unsigned char byte;

class MStarList;
class MAstroCatalog;

class StarCatalog : public SlaStars
{
private:

    int fW;
    int fH;

 
    MAstroCatalog *fAstro;

    double   fPixSize;  // [rad/pix] size of one pixel
    double   fSinAngle;
    double   fCosAngle;
    double   fAngle;

    float    fLimitMag; // [M] limiting magnitude for display

    AltAz    fAltAz;    // [rad]
    RaDec    fRaDec;    // [rad]

    static void DrawCross(byte *img, const int x, const int y);
    static void DrawCircle(int color, byte *img, int xx, int yy, int size);

    void   SetRaDec(const RaDec &radec);

    int    fBoxX;
    int    fBoxY;

public:
    StarCatalog(MObservatory::LocationName_t key);
    virtual ~StarCatalog();

    void   SetAltAz(const AltAz &altaz);

    void GetImg(byte *img, byte *cimg, MStarList &list) const;
    void PaintImg(unsigned char *buf, int w, int h);

    const AltAz GetAltAz() const /*[deg]*/ { return fAltAz*TMath::RadToDeg(); }
    const ZdAz  GetZdAz() const  /*[deg]*/ { return ZdAz(TMath::Pi()/2-fAltAz.Alt(), fAltAz.Az())*kRad2Deg; }
    const RaDec GetRaDec() const /*[deg]*/ { return fRaDec*kRad2Deg; }

    void  SetPixSize(const double pixsize);
    void  SetLimitMag(const float mag);
    void  SetRotationAngle(const double angle) { fSinAngle = sin(angle/kRad2Deg); fCosAngle = cos(angle/kRad2Deg); fAngle=angle; }
    void  Reload();

    double GetRotationAngle() { return fAngle; }

    double GetPixSize() const;

    //AltAz CalcAltAzFromPix(Double_t pixx, Double_t pixy) const;
    ZdAz  CalcDeltaZdAzFromPix(Double_t pixx, Double_t pixy) const;

    virtual void SetMjd(double mjd);

    void SetPointing(double mjd, const RaDec &radec)
    {
        SetMjd(mjd); SetRaDec(radec);
    }

    //void   CalcStars(MStarList &list);
    void   CalcStars(MStarList &list, int xc, int yc, float xo, float yo) const;
    static void DrawStars(MStarList &list, byte *img);

    void SetBox(int box)   { fBoxX = fBoxY = box; }
    void SetBox(int boxx, int boxy)   { fBoxX = boxx; fBoxY=boxy; }

    ClassDef(StarCatalog, 0)
};

#endif
