#ifndef COSY_MsgQueue
#define COSY_MsgQueue

#ifndef __CINT__
#include <list>
#include <mutex>
#include <thread>
#include <vector>
#include <condition_variable>
#endif

#define WM_NULL 0x0000
#define WM_QUIT 0xffff

class MsgQueue
{
private:
    size_t fSize;                 // Only necessary for before C++11

#ifndef __CINT__
    std::list<std::pair<int, std::vector<char>>> fList;

    std::mutex fMutex;        // Mutex needed for the conditional
    std::condition_variable fCond; // Conditional
#endif

    enum state_t
    {
        kIdle,
        kRun,
        kStop,
        kAbort,
    };

    state_t fState;               // Stop signal for the thread
#ifndef __CINT__
    std::thread fThread;      // Handle to the thread
#endif

    void Thread();

public:
    MsgQueue();
    virtual ~MsgQueue();

    int Break() const;

    void CancelThread();

    virtual int Proc(int msg, void *mp1);
    int Proc(int msg) { return Proc(msg, 0); }

    void *PostMsg(int msg, void *mp1, int size);
    void *PostMsg(int msg) { return PostMsg(msg, 0, 0); }
};

#endif
