/* -*-C-*-
 * linux.h - linux to dpm type conversions
 *
 *-----------------------------------------------------------------------
 *
 *                Copyright (c) 1997 JANZ Computer AG
 *                        All Rights Reserved
 *
 * Permission is hereby granted to licensees of JANZ Computer AG
 * products to use or abstract this computer program for the sole
 * purpose of implementing a product based on JANZ Computer AG
 * products.   No other rights to reproduce, use, or disseminate
 * this computer program, whether in part or in whole, are granted.
 *
 * JANZ Computer AG makes no representation or warranties with respect
 * to the performance of this computer program, and specifically
 * disclaims any responsibility for any damages, special or consequential,
 * connected with the use of this program.
 *
 * JANZ Computer AG products are not authorized for use as critical
 * components in life support devices or systems without the express
 * written approval of JANZ Computer AG.
 *
 *-----------------------------------------------------------------------
 *
 * $Id: linux.h,v 1.1 2001-04-09 13:32:55 tbretz Exp $
 *
 *-----------------------------------------------------------------------
 */

/*
 * $Log: not supported by cvs2svn $
 * Revision 1.1  1997/09/29 15:50:04  root
 * Initial revision
 *
 * Revision 1.1  1997/04/01 14:54:59  root
 * Initial revision
 *
 */


#ifndef linux_DEFINED
#define linux_DEFINED
#if __cplusplus
extern "C" {
#endif

/***** defines **************************************************************/

#define	TRUE	(1)
#define	FALSE	(0)
#define	ERROR	(-1)
#define	intLock(x)		disable_irq(x)
#define	intUnlock(x)		enable_irq(x)

#define	DEV_HDR	int
#define	SEM_ID	int

#define FAST    register
#define IMPORT  extern
#define LOCAL   static
 
/***** typedefs *************************************************************/

typedef char            INT8;
typedef short           INT16;
typedef int             INT32;

typedef unsigned char   UINT8;
typedef unsigned short  UINT16;
typedef unsigned int    UINT32;

typedef unsigned char   UCHAR;
typedef unsigned short  USHORT;
typedef unsigned int    UINT;
typedef unsigned long   ULONG;

typedef int             BOOL;
typedef int             STATUS;
typedef int             ARGINT;

typedef void            VOID;

typedef int             (*FUNCPTR) ();     /* ptr to function returning int */
typedef void            (*VOIDFUNCPTR) (); /* ptr to function returning void */
typedef double          (*DBLFUNCPTR) ();  /* ptr to function returning double*/
typedef float           (*FLTFUNCPTR) ();  /* ptr to function returning float */

/***** function declarations  ***********************************************/

#if __cplusplus
}
#endif
#endif /* linux_DEFINED */
