#ifndef COSY_MSlewing
#define COSY_MSlewing

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

class Dkc;
class MCosy;

#ifndef MARS_MPointing
#include "MPointing.h"
#endif

class MSlewing
{
protected:
    MCosy *fCosy;

    bool SetAcc(Dkc *mac, Float_t acc);
    bool Break();

private:
    Float_t fVel;
    ZdAz    fAcc;

    Float_t fMaxResidual; // [rev] Maximum residual deviation to stop pointin

    void DoRelPos(const ZdAz &rd, const Bool_t axe1, const Bool_t axe2);
    void DoAbsPos(const ZdAz &rd, const Bool_t axe1, const Bool_t axe2);
    void SetPosVelocity(const ZdAz &res, Float_t vel);

    Double_t GetDiff(const ZdAz &za) const;

public:
    MSlewing(MCosy *cosy) : fCosy(cosy), fVel(0.1), fAcc(0,0), fMaxResidual(1./16384) { }
    virtual ~MSlewing() { }

    void SetPointAcc(Float_t zd, Float_t az) { fAcc.Zd(zd); fAcc.Az(az); }
    void SetPointVelocity(Float_t vel) { fVel = vel; }
    int  SetPosition(const ZdAz &dst, Bool_t track=kFALSE);
    void SetMaxResidual(Float_t ac) { fMaxResidual = ac; }

    ClassDef(MSlewing, 0)
};

#endif
