#ifndef CAOS_MCaos
#define CAOS_MCaos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef CAOS_Leds
#include "Leds.h"
#endif
#ifndef CAOS_Ring
#include "Ring.h"
#endif

#ifndef COSY_PixClient
#include "PixClient.h" // byte
#endif

class TFile;
class TH1F;
class TH2F;
class TGraph;

class MTime;
class ZdAz;

class MCaos : public MParContainer
{
private:
    TFile         *fFile;       // File we may write data to

    Leds           fPositions;

    Leds          *fLeds;
    Double_t       fEvtTime;
    Double_t       fZenithDist;
    Double_t       fAzimuth;

    TH1F          *fHistpr;
    TH2F         **fHistled;
    TH1F          *fHistallw;
    TH1F         **fHistw;

    TH2F          *fHistprxpry;

    TGraph        *fGraphprx;
    TGraph        *fGraphpry;
    TGraph        *fGraphw;
    TGraph        *fGraphr;

    Short_t       fMinNumberLeds;      // minimum number of detected leds required
    Double_t      fMinRadius;          // minimum radius for cut in ring radius
    Double_t      fMaxRadius;          // maximum radius for cut in ring radius
    UShort_t      fSizeBox;            // Size of the search box (side length in units of pixels)
    Double_t      fCut;                // Cleaning level (sigma above noise)
    Double_t      fArcsecPerPixel;     // Conversion from arcseconds to pixel

    Int_t fNumDetectedLEDs;
    Int_t fNumDetectedRings;

public:
    MCaos(const char *name=0, const char *title=0)
        : fFile(NULL), fHistpr(NULL), fMinNumberLeds(5),
        fMinRadius(265), fMaxRadius(268), fSizeBox(19), fCut(3.0)
    {
        fLeds = new Leds;
    }

    ~MCaos()
    {
        CloseFile();
        DeleteHistograms();
        delete fLeds;
    }

    void AddPosition(Float_t x, Float_t y, Float_t dx, Float_t dy)
    {
        fPositions.Add(x, y, dx, dy);
    }

    void ReadResources(const char *name="leds.txt");

    void OpenFile();
    void CloseFile();
    
    void SetMinNumberLeds(Short_t n)
    {
	fMinNumberLeds = n;
    }

    void SetMinRadius(Double_t min) { fMinRadius=min; }
    void SetMaxRadius(Double_t max) { fMaxRadius=max; }

    void InitHistograms();
    void DeleteHistograms();
    void ShowHistograms();
    void ResetHistograms();

    Int_t GetNumDetectedLEDs() const  { return fNumDetectedLEDs; }
    Int_t GetNumDetectedRings() const { return fNumDetectedRings; }

    Double_t GetArcsecPerPixel() const { return fArcsecPerPixel; }

    Ring Run(byte *img, bool printl, bool printr, const ZdAz &pos, 
             const MTime &t);

    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);
};

#endif
