#ifndef COSY_MGAccuracy
#define COSY_MGAccuracy

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef COSY_MGEmbeddedCanvas
#include "MGEmbeddedCanvas.h"
#endif

class TGraph;
class TLine;
class TText;

class ZdAz;

class MGAccuracy : public MGEmbeddedCanvas
{
protected:
    TLine  *fLin1;
    TLine  *fLin2;

    TText  *fTxt;

    TLine  *fBar;

    TGraph *fGraph;

    Double_t fTime;
    Double_t fColorScale;

    void DrawCoordinateSystem();

    void InitText();
    void InitCross();
    void InitBar();

    void UpdateCross(Float_t x, Float_t y);
    void UpdateText(Float_t acc);
    void UpdateGraph(Float_t acc);
    void Update(Float_t zd, Float_t x, Float_t y);

public:
    MGAccuracy(const TGWindow* p, const UInt_t w);
    ~MGAccuracy();

    void DrawText(const char *c1, const char *c2, const char *c3, const char *txt);
    void DrawCircles(Double_t rad=79.1);

    void SetColorScale(Double_t scale=1) { fColorScale=scale; }

    void Update(ZdAz &pos, ZdAz &acc);

    ClassDef(MGAccuracy, 0)
};

#endif // COSY_MGAccuracy
