//compile with:
//g++44 -std=c++0x -o fitsCompare -DHAVE_ZLIB=1 -lz dataChecker.cpp
#include <string.h>
#include <fstream>
#include <map>
#include <unordered_map>

using namespace std;
//#include <iostream>

#include "externals/fits.h"

using namespace std;

 /*
 *	Usage: program-name <file1> <file2> <optional -v for verbose output>
 *
 *	
 *
 *
 *
 *
 */
 
 fits* file1;
 fits* file2;
 char* file1Data;
 char* file2Data;

 int customReturn(int code)
 {
 	if (file1)
	{
		file1->close();
		delete file1;
	}
	if (file2)
	{
		file2->close();
		delete file2;
	}
	if (file1Data)
	{
		delete[] file1Data;
	}
	if (file2Data)
	{
		delete[] file2Data;
	}
	exit(code);
 }
 
int main(int argc, char** argv)
{
	if (argc < 3)
		return -1;
		
	bool verbose=false;
	
	if (argc > 3 &&
	    !strcmp(argv[3], "-v"))
	    verbose=true;
	    
	string filename1(argv[1]);
	string filename2(argv[2]);
	file1=NULL;
	file2=NULL;
	file1Data=NULL;
	file2Data=NULL;
	try
	{
		file1 = new fits(filename1);
		file2 = new fits(filename2);
	}
	catch (std::runtime_error e)
	{
		if (verbose)
			cout << "Could not open at least one of the two files." << endl;
		else
			cout << 2 << endl;
		return -1;
	}	
	
	//get the columns in the file. 
	fits::Table::Columns columns1=file1->GetColumns();
	fits::Table::Columns columns2=file2->GetColumns();
	
	if (columns1.size() != columns2.size())
	{
		if (verbose)
			cout << "Different number of columns" << endl;
		else
			cout << "1" << endl;
		customReturn(-1);
	}
	
	long totalSize=0;
	for (auto it=columns1.begin(), jt=columns2.begin(); it != columns1.end(); it++, jt++)
	{
		if (it->first != jt->first)
		{
			if (verbose)
				cout << "Different column names" << endl;
			else
				cout << "1" << endl;
			customReturn(-1);
		}
		if ((it->second.offset != jt->second.offset) ||
		    (it->second.num != jt->second.num) ||
		    (it->second.size != jt->second.size) ||
		    (it->second.type != jt->second.type) ||
		    (it->second.unit != jt->second.unit))
		{
			if (verbose)
				cout << "Different column def" << endl;
			else
				cout << "1" << endl;
			customReturn(-1);
		}
		
		totalSize += it->second.size * it->second.num;

	}
	
	char* file1Data = new char[totalSize];
	char* file2Data = new char[totalSize];
	
	if ((sizeof(long) != 8) ||
	    (sizeof(int) != 4) ||
	    (sizeof(short) != 2))
	    {
	    	if (verbose)
		    	cout << "OS IS NOT SUITABLE (32bits ?) please use a 64 bits system" << endl;
		else
			cout << "2" << endl;
		customReturn(-1);
	    }
	
	for (auto it=columns1.begin(); it != columns1.end(); it++)
	{
		switch (it->second.size) {
		case 1:
			file1->SetPtrAddress(it->first, &file1Data[it->second.offset], it->second.num);
			file2->SetPtrAddress(it->first, &file2Data[it->second.offset], it->second.num);
			break;
		case 2:
			file1->SetPtrAddress(it->first, (short*)(&file1Data[it->second.offset]), it->second.num);
			file2->SetPtrAddress(it->first, (short*)(&file2Data[it->second.offset]), it->second.num);
			break;
		case 4:
			file1->SetPtrAddress(it->first, (int*)(&file1Data[it->second.offset]), it->second.num);
			file2->SetPtrAddress(it->first, (int*)(&file2Data[it->second.offset]), it->second.num);
			break;
		case 8:
			file1->SetPtrAddress(it->first, (long*)(&file1Data[it->second.offset]), it->second.num);
			file2->SetPtrAddress(it->first, (long*)(&file2Data[it->second.offset]), it->second.num);
			break;
		default:
			if  (verbose)
				cout << "Unkown column element size: " << it->second.size << endl;
			else
				cout << "2" << endl;
			customReturn(-1);
		};
	}
	
	int numRows1 = file1->GetInt("NAXIS2");
	int numRows2 = file2->GetInt("NAXIS2");
	if (numRows1 > numRows2)
	{
		if (verbose)
			cout << "looks like the files has different number of rows: " << numRows1 << " vs " << numRows2 << endl;
		else
			cout << "1" << endl;
		customReturn(0);
	}
	int row=0;
	if (verbose)
		cout << "files have " << numRows1 << " rows" << endl << endl;
	while (file1->GetNextRow() &&
		file2->GetNextRow() &&
		row < numRows1) 
	{
		if (verbose)
		{
			cout << "\rrow: " << row;
			cout.flush();
		}
		for (int i=0;i<totalSize;i++)
		{
			if (file1Data[i] != file2Data[i])
			{
				if (verbose)
					cout << "Files differ... i: " << i << " " << file1Data[i] << " " << file2Data[i] << endl;
				else
					cout << "1" << endl;
				customReturn(0);
			}
		}
		row++;
	}
	if (numRows1 != numRows2)
	{
		if (verbose)
			cout << "Archive has more rows. orig. data is fine" << endl;
		else
			cout << "3" << endl;
	}
	if (verbose)
		cout << "Files data is identical" << endl;
	else
		cout << "0" << endl;
	customReturn(0);
}
