#!/bin/bash
#sourceFolder="./backup"
#destFolder="./fixed"

#entries=`find $sourceFolder -type f -name '*.fits' | sort`

#for entry in ${entries[@]}
#do
#	echo $entry" "$destFolder
#	cp $entry $destFolder
#done

#entries=`find $destFolder -type f -name '*.fits' | sort`

#for entry in ${entries[@]}
#do

if [ "$#" != "5" ]
then
	echo "Error: repairAuxFile.sh should be called with 4 arguments please"
	exit
fi
entry=$1
errorFile=$2
wrongMjdFile=$3
reportFile=$4
processErrorFile=$5
	#verify file with fverify
	result=`fverify $entry 2>/dev/null | grep '0 error(s)'`
	if [ "$result" != "" ]
	then
		mjdref=`/home/isdc/lyard/FACT++/fitsdump $entry -h 2>/dev/null | grep 'MJDREF' | grep -E -o '[0-9]+'`
		if [ "$mjdref" != 40587 ]
		then
			echo "$entry" >> $wrongMjdFile
			result=""
		fi
	else
		echo "$entry" >> $errorFile
	fi
	
	if [ "$result" == "" ]
	then
	#fix it !
#		echo $entry
		headerSize=`ENDfixer $entry 2>/dev/null`
		echo "Fixed END $entry" >> $reportFile
		if [ "$headerSize" == "Error: header length not acceptable" ] || [ "$headerSize" == "Error: too much header space after END keyword" ] 
		then 
			echo "File "$entry" looks really messed up: "$headerSize >> $errorFile
			exit
		else 
			filesize=`stat -c%s $entry`
#			echo $headerSize" "$filesize
			numrows=`/home/isdc/lyard/FACT++/fitsdump $entry -h 2>/dev/null | grep 'NAXIS2' | awk '{ print $4 }' | grep -E -o '[0-9]+'`
			if [ "$numrows" == "" ]
			then
				echo "Cannot fitsdump $entry" >> $processErrorFile
				rm $entry
				exit
			fi
			rowWidth=`/home/isdc/lyard/FACT++/fitsdump $entry -h 2>/dev/null | grep 'NAXIS1' | awk '{ print $4 }' | grep -E -o '[0-9]+'`
			
			#is there any extra row that we can keep ?
			#let RowCheck examine the time markers
			numrows2=`RowChecker $entry $headerSize $rowWidth 0 $numrows 2>/dev/null`
			if [ $numrows2 -gt $numrows ]
			then
				numrows=$numrows2
				totSize=`echo " $headerSize + $numrows * $rowWidth " | bc -l`
				fitsSize=`echo " 2880 - ($totSize % 2880) " | bc`
				fitsSize=`echo " $totSize + $fitsSize " | bc -l`
#				echo $headerSize" "$numrows" "$rowWidth" "$totSize" "$fitsSize
#				echo " FileSize: "$filesize" should be "$fitsSize
				truncate -s $totSize $entry 2>/dev/null
				truncate -s $fitsSize $entry 2>/dev/null
				echo "Resized   $entry" >> $reportFile
			fi
		fi
	fi
#done
