#!/bin/bash

sourceFolder=$1
archiveFolder=$2
suffix=$3

#are the arguments subfolders of /data00/fact-construction and /archive/fact ?
sourceOk=`echo $sourceFolder | sed "s/data00\/fact-construction\/raw/OK/"`
archiveOk=`echo $archiveFolder | sed "s/archive\/fact\/rev_1\/raw/OK/"`

sourceOk=`echo $sourceOk | grep OK`
archiveOk=`echo $archiveOk | grep OK`

if [ "$sourceOk" == "" ]
then
	echo "source folder not good."
	exit
fi

if [ "$archiveOk" == "" ]
then
	echo "archive folder not good"
	exit
fi

uncompressedFolder=`echo $sourceFolder | sed "s/data00/data03/"`

#do the listing of the files to be checked
entries=`find $sourceFolder -type f -name '*.fits.gz' | sort`

for entry in ${entries[@]}
do
	echo "$entry" >> GGfileSequence$suffix.txt
	
	uncompressedEntry=`echo $entry | sed "s/data00/data03/"`
	uncompressedEntry=`echo $uncompressedEntry | sed "s/.gz//"`
	archiveEntry=`echo $entry | sed "s/data00\/fact-construction/archive\/fact\/rev_1/"`
	corruptedFile="0"
	if [ -f $uncompressedEntry ]
	then
		result=`fverify $uncompressedEntry 2>/dev/null | grep '0 error(s)'`
		if [ "$result" == "" ]
		then
			if [ -f $archiveEntry ]
			then
				echo "$entry" >> GGcorruptFiles$suffix.txt
			fi
			corruptedFile="1"
		fi
	else
		echo "$entry" >> GGmissingUncompressed$suffix.txt
		echo "$entry is missing uncompressed"
		continue
	fi
	
	if [ -f $archiveEntry ]
	then
		result=`/home_nfs/isdc/lyard/FACT++/fitsCompare $entry $archiveEntry`
		if [ "$result" == "0" ]
		then
			echo "$entry" >> GGidenticalFiles$suffix.txt
			echo "$entry is fine"
			continue
		fi
		if [ "$result" == "1" ]
		then
			echo "$entry" >> GGdifferentFiles$suffix.txt
			echo "$entry differs from its archived version"
			continue
		fi
		if [ "$result" == "2" ]
		then
			echo "$entry" >> GGunexpectedErrors$suffix.txt
			echo "$entry encountered an unexpected error"
			continue
		fi
		if [ "$result" == "3" ]
		then
			echo "$entry" >> GGfineWithMoreRows$suffix.txt
			echo "$entry is fine (with more rows !"
			continue
		fi
		if [ "$corryuptedFile" == "1"]
		then
			echo "$entry is corrupted and produced unkown error $result"
		else
			echo "$entry produced unkown error $result"
		fi	
		echo "$entry $result" >> GGunknownErrors$suffix.txt
	else
		if [ "$corruptedFile" == "1" ]
		then
			echo "$entry" >> GGreallymessedup$suffix.txt
			echo "$entry is really messed up"
		else
			echo "$entry" >> GGmissingArchive$suffix.txt
			echo "$entry is missing archive"
		fi
	fi
done
