#!/bin/bash
#
# This script checks, if there are WARNs or ERRORs in the processlog of 
# the last night and sends them to the emailadresse(s) in $erradr
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

oldprocesslog=$processlogpath/process`date +%F --date="-1day"`.log

if grep WARN $oldprocesslog >/dev/null
then 
   grep WARN $oldprocesslog | mail -s 'found warnings in '$oldprocesslog $erradrs
   printprocesslog "INFO sent warnings to "$erradrs
fi

if grep ERROR $oldprocesslog >/dev/null
then 
   grep ERROR $oldprocesslog | mail -s 'found errors in '$oldprocesslog $erradrs
   printprocesslog "INFO sent errors to "$erradrs
fi

printprocesslog "INFO finished $0"

