#!/bin/bash

numnetworks=6

vals=(`/sbin/ifconfig -s | tr -s ' ' | cut -d' ' -f1,5,9 | grep -v RX `)
#echo ${vals[@]}
#echo ${#vals[@]}

numvals=`echo " $numnetworks * 3 + 3" | bc -l`
#echo $numvals
if [ ${#vals[@]} -ne $numvals ]
then 
   echo "ERROR Not all "$numnetworks" networks available."
   exit
fi

for (( i=0 ; i < $numnetworks ; i++ )) 
do 
   query="SELECT fRXErrors, fTXErrors FROM NetworkErrors WHERE fEth="$i" ORDER BY fTime DESC LIMIT 0,1;" 
   #echo $query
   errors=( `/usr/bin/mysql -u systemstatus --host=fact01 systemstatus -s -e "$query"` )
   #echo ${errors[@]}
   if [ ${errors[0]} -lt ${vals[$i*3+1]} ]
   then 
      echo "RX errors increased to "${errors[0]}" on eth"$i
   fi
   if [ ${errors[1]} -lt ${vals[$i*3+2]} ]
   then
      echo "TX errors increased to "${errors[0]}" on eth"$i
   fi
   query="INSERT NetworkErrors SET fEth="$i", fRXErrors="${vals[$i*3+1]}", fTXErrors="${vals[$i*3+2]}", fTime=Now()"
   /usr/bin/mysql -u systemstatus --host=fact01 systemstatus -e "$query"
done

