#!/bin/bash


source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   if [ "$1" = "" ]
   then 
      # the day after tomorrow
      dates=( `date +%Y/%m/%d --date="+1day" --utc` )
   else
      getdates $1
   fi
fi



for date in ${dates[@]}
do 
   printprocesslog "INFO insert schedule for the night of "$date
   #echo "INFO inserting schedule for the night of "$date
   date2=`echo $date | sed -e 's/\//-/g'`
   year=`echo $date | cut -c 1-4`
   month=`echo $date | cut -c 6-7`
   day=`echo $date | cut -c 9-10`
   query="SELECT u FROM calendar.Data WHERE y="$year" AND m="$month"-1 AND d="$day" AND u NOT IN ('ETHZ','TUDO','ISDC','UNIWUE')"
   printprocesslog "DEBUG "$query
   #echo "DEBUG "$query
   shifters=`sendquery`
   if [ "$shifters" = "" ]
   then
       printprocesslog "INFO No shifter found in calendar -> Do not insert a schedule."
       echo "INFO No shifter found in calendar -> Do not insert a schedule."
       continue
   else
       checkshifter=`echo $shifters | grep moon`
       if [ "$checkshifter" != "" ]
       then
          printprocesslog "INFO Full moon night -> Do not insert a schedule."
          #echo "INFO Full moon night -> Do not insert a schedule."
          continue
       fi
   fi
   
   printprocesslog "DEBUG /home/fact/FACT++.dbg/makeschedule --config /home/fact/makeschedule_gate.rc --date $date2 --enter-schedule-into-database true  2>/dev/null | grep 'Schedule entered successfully into database.\|Schedule not empty.'"
   #echo "DEBUG /home/fact/FACT++.dbg/makeschedule --config /home/fact/makeschedule_gate.rc --date $date2 --enter-schedule-into-database true  2>/dev/null | grep 'Schedule entered successfully into database.\|Schedule not empty.'"
   check=`/home/fact/FACT++.dbg/makeschedule --config /home/fact/makeschedule_gate.rc --date $date2 --enter-schedule-into-database true  2>/dev/null | grep 'Schedule entered successfully into database.\|Schedule not empty.'`
   case $check in 
     "Schedule entered successfully into database.") 
        printprocesslog "INFO schedule for "$date2" successfully inserted. "
        ;;
     "Schedule not empty.") 
        printprocesslog "WARN schedule for "$date2" not empty -> cannot insert schedule."
        ;;
     *) 
        printprocesslog "ERROR problem with inserting schedule for "$date" ("$check")"
        ;;
   esac
done

finish
