#!/bin/bash
#
# This script checks, if there are WARNs or ERRORs in the processlog of 
# the last night and sends them to the emailadresse(s) in $erradr
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

if ! [ "$1" = "day" ] && ! [ "$1" = "hour" ]
then 
   #echo "wrong option "$1" (only min and nights valid)."
   echo "wrong option "$1" (only day and hour valid)."
   finish
fi

# check for connection problems or full disks every hour
if [ "$1" = "hour" ]
then 
   lastdate=`date +'%F %H' --date="-1hour"`
   processlogfile=$processlogpath/process`date +%F --date="-1hour"`.log
   
   if grep -E "^$lastdate.*DISK" $processlogfile >/dev/null
   then 
      grep -E "^$lastdate.*DISK" $processlogfile | mail -s 'disk full ('$processlogfile')' $deladrs
      printprocesslog "INFO sent full-disk info to "$deladrs
   fi

   if grep -E "^$lastdate.*CONNECTION" $processlogfile >/dev/null
   then
      grep -E "^$lastdate.*CONNECTION" $processlogfile | mail -s 'found connection problems found ('$processlogfile')' $erradrs
      printprocesslog "INFO sent connection-problem info to "$erradrs
   fi
fi

# check for errors and warnings once a day
if [ "$1" = "day" ]
then
   lastdate=`date +'%F ' --date="-1hour"`
   processlogfile=$processlogpath/process`date +%F --date="-1hour"`.log
   
   if grep -E "^$lastdate.*WARN" $processlogfile >/dev/null
   then
      grep -E "^$lastdate.*WARN" $processlogfile | mail -s 'found warnings in '$processlogfile $erradrs
      printprocesslog "INFO sent warnings to "$erradrs
   fi

   if grep -E "^$lastdate.*ERROR" $processlogfile >/dev/null
   then
      grep -E "^$lastdate.*ERROR" $processlogfile | mail -s 'found errors in '$processlogfile $erradrs
      printprocesslog "INFO sent errors to "$erradrs
   fi
fi

printprocesslog "INFO finished $0 $1"

